<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($status)) ?> kpi_reports.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'landscape'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themesTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "Strategic Goals"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($status)) ?> kpi_reports.xlsx');
    });
</script>



<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>


    <h2 style="text-align:center;" class="large-text"><?= ucfirst($status) ?> KPI Reports</h2>
    <p style="text-align:center;">Exported at: <?= (new DateTime())->format('h:i A d M Y') ?></p>
    

    <?php if (!empty($reports)) : ?>
        <table id="themesTable">
            <thead>
                <tr>
                    <th scope="col">KPI</th>
                    <th scope="col">Submitted By/At</th>
                    <th scope="col">Comment</th>
                    <th scope="col">Status</th>
                    <th scope="col">Approved/Rejected By/At</th>
                    <th scope="col">CSO Comment</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reports as $report) : ?>
                    <tr>
                        <?php
                        $color = '';
                        if ($report['status'] === 'pending') {
                            $color = 'color:yellow';
                        } elseif ($report['status'] === 'rejected') {
                            $color = 'color:red';
                        } else {
                            $color = 'color:green';
                        }
                        ?>
                        <td><?= esc($report['kpi']) ?></td>
                        <td><?= esc($report['project_lead']) ?>
                            <br>
                            <?= $report['created_at']
                                ? (new DateTime($report['created_at']))->format('h:i A d M Y')
                                : '-' ?>
                        </td>
                        <td><?= html_entity_decode($report['submitted_comment']) ?></td>
                        <td><?= esc($report['status']) ?></td>
                        <td><?= esc($report['cso']) ?>
                            <br>
                            <?= $report['approved_at']
                                ? (new DateTime($report['approved_at']))->format('h:i A d M Y')
                                : '-' ?>
                        </td>
                        <td><?= esc($report['cso_comment']) ?></td>
                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>