<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($theme['title'])) ?> theme.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'landscape'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themeTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "Theme"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($theme['title'])) ?>theme.xlsx');
    });
</script>



<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>

    <h2 class="large-text">Theme: <?= esc($theme['title']) ?></h2>

    <!-- loop out theme details from theme controller -->
    <?php if (!empty($groupedData)) : ?>
        <table id="themeTable">
            <thead>
                <tr>
                    <th>Strategy Framework Perspective</th>
                    <th>High Level Goals</th>
                    <th>Initiatives</th>
                    <th>Timeline</th>
                    <th>Responsibility</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($groupedData as $perspectiveName => $goals): ?>
                    <?php foreach ($goals as $goalData): ?>
                        <tr>
                            <td style="background-color: #f0f0f0;"><?= esc($perspectiveName) ?></td>
                            <td><?= html_entity_decode(esc($goalData['goal']['description'])) ?></td>

                            <!-- Initiatives (unordered list) -->
                            <td>
                                <ul>
                                    <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                        <li class="mb-3"><?= esc($initiative['name']) ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </td>
                            <td>
                                <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                    <p>
                                        <?= !empty($initiative['end_date'])
                                            ? (new DateTime($initiative['end_date']))->format('d M, Y')
                                            : '-' ?>
                                    </p>
                                <?php endforeach; ?>
                            </td>

                            <!-- Owners (unordered list) -->
                            <td>
                                <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                    <p>
                                        <?= !empty($initiative['owners'])
                                            ? esc(implode(' | ', $initiative['owners']))
                                            : '-' ?>
                                    </p>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div>No initiatives found for this theme.</div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>