<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px;">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function () {
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3,
            filename: '<?= ucwords(esc($organization['name'])) ?> strategy-map.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 3, useCORS: true },
            jsPDF: { unit: 'in', format: 'a4', orientation: 'landscape' }
        };

        html2pdf().set(opt).from(element).save();
    });

    document.getElementById('exportExcel').addEventListener('click', function () {
        var table = document.getElementById('strategyTable');
        var workbook = XLSX.utils.table_to_book(table, { sheet: "Strategy Map" });
        XLSX.writeFile(workbook, '<?= ucwords(esc($organization['name'])) ?> strategy_map.xlsx');
    });
</script>

<div id="pdfContent" style="padding: 20px;">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>

    <h2 style="text-align:center;"><?= ucwords(esc($organization['name'])) ?> Strategy Map</h2>

    <?php
        $goalsWithPerspective = $strategyMatrix['with_perspective'] ?? [];
        $goalsWithoutPerspective = $strategyMatrix['without_perspective'] ?? [];
    ?>

    <div class="table-responsive">
        <?php if (!empty($perspectives) && !empty($goalsWithPerspective)) : ?>
            <?php
                $goalMap = [];
                foreach ($goalsWithPerspective as $goal) {
                    $pid = $goal['bscperspective_id'];
                    $tid = $goal['theme_id'];
                    $goalMap[$pid][$tid][] = $goal['description'];
                }
            ?>
            <table id="strategyTable" border="1" cellspacing="0" cellpadding="5" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr style="background-color: #e2e2e2;">
                        <th></th>
                        <?php foreach ($themes as $theme): ?>
                            <th><?= ucfirst(esc($theme['title'])) ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($perspectives as $persp): ?>
                        <tr>
                            <td style="background-color: #f0f0f0;"><strong><?= ucfirst(esc($persp['name'])) ?></strong></td>
                            <?php foreach ($themes as $theme): ?>
                                <td>
                                    <?php
                                    $goals = $goalMap[$persp['id']][$theme['id']] ?? [];
                                    if ($goals): ?>
                                        <?php foreach ($goals as $goal): ?>
                                            <p><?= html_entity_decode($goal) ?></p>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        &mdash;
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

        <?php elseif (!empty($goalsWithoutPerspective)) : ?>
            <table id="strategyTable" border="1" cellspacing="0" cellpadding="5" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr style="background-color: #e2e2e2;">
                        <?php foreach ($themes as $theme): ?>
                            <th><?= ucfirst(esc($theme['title'])) ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <?php foreach ($themes as $theme): ?>
                            <td>
                                <?php
                                $goals = $goalsWithoutPerspective[$theme['id']] ?? [];
                                if ($goals): ?>
                                    <?php foreach ($goals as $goal): ?>
                                        <p><?= html_entity_decode($goal) ?></p>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    &mdash;
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                </tbody>
            </table>
        <?php else : ?>
            <p style="text-align: center;">No goals available for strategy map.</p>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
