<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        document.getElementById('filter').style.display = 'none';
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($organization['name'])) ?> strategic-themes.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'portrait'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themesTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "Strategic Themes"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($organization['name'])) ?> strategic_themes.xlsx');
    });
</script>



<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>


    <h2 style="text-align:center;" class="large-text"><?= ucwords(esc($organization['name'])) ?> Strategic Themes </h2>
    <div class="filter text-end me-5">
        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown">Filter by</a>
        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
            <li class="dropdown-header text-start">
                <h6>Status</h6>
            </li>

            <li><a class="dropdown-item" href="<?= base_url('themes?status=completed&action=download') ?>">Completed</a></li>
            <li><a class="dropdown-item" href="<?= base_url('themes?status=active&action=download') ?>">Active</a></li>
            <li><a class="dropdown-item" href="<?= base_url('themes?status=inactive&action=download') ?>">Inactive</a></li>
            <li><a class="dropdown-item" href="<?= base_url('themes?action=download') ?>">Show All</a></li>

        </ul>
    </div>

    <?php if (!empty($themes)) : ?>
        <table id="themesTable">
            <thead>
                <tr>
                    <th scope="col">Theme</th>
                    <th scope="col">Description</th>
                    <th scope="col">Timeline</th>
                    <th scope="col">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($themes as $theme) : ?>
                    <tr>
                        <td><?= esc($theme['title']) ?></td>
                        <td><?= esc($theme['description']) ?? '' ?></td>
                        <td><?= (new DateTime($theme['timeline']))->format('d F, Y') ?></td>
                        <td><?= esc($theme['status']) ?? '' ?></td>
                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>