<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>
<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('emails') ?>">Emails</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div>
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">
            <div class="col-lg-9">
                <div class="card recent-sales">
                    <div class="card-body">
                        <h4 class="text-center medium-text card-title">Send New Email</h4>

                        <form action="<?= base_url('emails/create') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;">
                            <?= csrf_field() ?>

                            <div class="row">
                                <!-- Recipient Type -->
                                <div class="mb-3 col-12">
                                    <label for="recipient_type" class="form-label">Recipient Type</label>
                                    <select name="recipient_type" id="recipient_type" class="form-input">
                                        <option value="">Select</option>
                                        <option value="individual" <?= set_value('recipient_type') === 'individual' ? 'selected' : '' ?>>Individual</option>
                                        <option value="group" <?= set_value('recipient_type') === 'group' ? 'selected' : '' ?>>Group</option>
                                    </select>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('recipient_type') : '' ?></p>
                                </div>

                                <!-- Individual Users (hidden by default) -->
                                <div class="mb-3 col-12" id="users_list" style="display: none;">
                                    <label class="form-label">Select Users</label>
                                    <div class="border p-2 rounded" style="max-height: 200px; overflow-y: auto;">
                                        <?php if (!empty($users)): ?>
                                            <?php foreach ($users as $user): ?>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        name="recipients[]"
                                                        value="user_<?= $user['id'] ?>"
                                                        id="user_<?= $user['id'] ?>">
                                                    <label class="form-check-label" for="user_<?= $user['id'] ?>">
                                                        <?= esc($user['name']) ?> (<?= esc($user['email']) ?>)
                                                    </label>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p class="text-muted">No users found in this organization.</p>
                                        <?php endif; ?>
                                    </div>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('recipients') : '' ?></p>
                                </div>

                                <!-- Organization Structures (hidden by default) -->
                                <div class="mb-3 col-12" id="structures_list" style="display: none;">
                                    <label class="form-label">Select Structures</label>
                                    <div class="border p-2 rounded" style="max-height: 200px; overflow-y: auto;">
                                        <?php if (!empty($structures)): ?>
                                            <?php foreach ($structures as $structure): ?>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        name="recipients[]"
                                                        value="group_<?= $structure['id'] ?>"
                                                        id="group_<?= $structure['id'] ?>">
                                                    <label class="form-check-label" for="group_<?= $structure['id'] ?>">
                                                        <?= esc($structure['name']) ?>
                                                    </label>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p class="text-muted">No structures found in this organization.</p>
                                        <?php endif; ?>
                                    </div>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('recipients') : '' ?></p>
                                </div>

                                <!-- Subject -->
                                <div class="mb-3 col-12">
                                    <label for="subject" class="form-label">Subject</label>
                                    <input type="text" class="form-input" name="subject" id="subject" value="<?= set_value('subject') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('subject') : '' ?></p>
                                </div>

                                <!-- Body -->
                                <div class="mb-3 col-12">
                                    <label for="body" class="form-label">Body</label>
                                    <textarea name="body" class="form-input" rows="5" id="editor"><?= set_value('body') ?></textarea>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('body') : '' ?></p>
                                </div>
                            </div>

                            <button class="btn btn-pink w-100">Send</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<!-- JavaScript to toggle and clear checkboxes -->
<script>
    document.getElementById('recipient_type').addEventListener('change', function() {
        let type = this.value;

        // Hide all lists first
        document.getElementById('users_list').style.display = 'none';
        document.getElementById('structures_list').style.display = 'none';

        // Clear all checkboxes when type changes
        document.querySelectorAll('#users_list input[type="checkbox"]').forEach(cb => cb.checked = false);
        document.querySelectorAll('#structures_list input[type="checkbox"]').forEach(cb => cb.checked = false);

        // Show relevant list
        if (type === 'individual') {
            document.getElementById('users_list').style.display = 'block';
        } else if (type === 'group') {
            document.getElementById('structures_list').style.display = 'block';
        }
    });
</script>

<?= $this->endSection() ?>