<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('emails') ?>">Emails</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">

                        <?php if (!empty($organization)) : ?>
                            <h5 class="card-title large-text">Emails
                                
                                    <span>| <a href="<?= base_url('emails/create') ?>" class="btn btn-sm text-primary">Send New Email</a></span>

                            </h5>

                        <?php endif; ?>
                        <?php if (!empty($emails)) : ?>
                            <table class="table table-hover table-bordered datatable">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Subject</th>
                                        <th scope="col" class="text-bg-secondary">Sent By</th>
                                        <th scope="col" class="text-bg-secondary">Date</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($emails as $email) : ?>
                                        <tr>
                                            <td>
                                                <a href="<?= base_url('emails/view?email=' . $email['slug']) ?>"><?= esc($email['subject']) ?></a>
                                            </td>
                                            <td><?= esc($email['sender_name']) ?></td>
                                            <td><?= (new DateTime($email['created_at']))->format('d F, Y') ?></td>
                                            <td>                                     <span class="badge 
                                        <?= $email['status'] === 'sent' ? 'bg-success' : ($email['status'] === 'scheduled' ? 'bg-warning' : 'bg-secondary') ?>">
                                        <?= ucfirst($email['status']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="<?= base_url('emails/view?email=' . $email['slug']) ?>"><i class="fa fa-eye" style="font-size:40px"></i></a>
                                            </td>

                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                        <?php else : ?>
                            <div class="alert alert-info">No emails found</div>
                        <?php endif; ?>
                    </div>

                </div>
            </div><!-- end users -->
        </div>
    </section>
</main>

<?= $this->endSection() ?>