
<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('emails') ?>">Emails</a></li>
                    <li class="breadcrumb-item active">Email Details</li>
                </ol>
            </nav>
        </div>
    <?php endif; ?>

    <section class="section dashboard">

        <div class="row">
            <?php if (!empty($emailRecord)) : ?>
                <div class="col-lg-12">
                    
                    <!-- Email Details Card -->
                    <div class="card border-primary mb-3">
                        <div class="card-header text-primary d-flex justify-content-between align-items-center">
                            <span><?= esc($emailRecord['subject']) ?></span>
                            <span class="badge 
                                <?= $emailRecord['status'] === 'sent' ? 'bg-success' : ($emailRecord['status'] === 'scheduled' ? 'bg-warning' : 'bg-secondary') ?>">
                                <?= ucfirst($emailRecord['status']) ?>
                            </span>
                        </div>
                        <div class="card-body">
                            <p class="card-text"><?= html_entity_decode($emailRecord['body']) ?></p>
                            <p class="card-text mt-3">
                                <span class="text-muted">From: <?= esc($emailRecord['sender_name']) ?> | </span>
                                <span class="text-muted">
                                    <?= (new DateTime($emailRecord['created_at']))->format('h:i A d M Y') ?>
                                </span>
                            </p>
                        </div>
                    </div>

                    <!-- Recipients Table -->
                    <?php if (!empty($emailRecipients)) : ?>
                        <div class="card">
                            <div class="card-header">
                                <strong>Recipients</strong>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Recipient Name</th>
                                            <th>Email</th>
                                            <th>Structure</th>
                                            <th>Status</th>
                                            <th>Sent At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($emailRecipients as $index => $recipient) : ?>
                                            <tr>
                                                <td><?= $index + 1 ?></td>
                                                <td><?= esc(trim(($recipient['recipient_name'] ?? ''))) ?></td>
                                                <td><?= esc($recipient['recipient_email'] ?? '-') ?></td>
                                                <td><?= esc($recipient['structure_name'] ?? '-') ?></td>
                                                <td>
                                                    <span class="badge 
                                                        <?= $recipient['status'] === 'sent' ? 'bg-success' : ($recipient['status'] === 'scheduled' ? 'bg-warning' : 'bg-secondary') ?>">
                                                        <?= ucfirst($recipient['status']) ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?= !empty($recipient['sent_at']) ? (new DateTime($recipient['sent_at']))->format('h:i A d M Y') : '-' ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php else : ?>
                        <p class="text-muted mt-3">No recipients found for this email.</p>
                    <?php endif; ?>

                </div>
            <?php else : ?>
                <p class="text-muted">Email not found.</p>
            <?php endif; ?>
        </div>

    </section>
</main>

<?= $this->endSection() ?>
