<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-lg-9">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h1 class="my-4 medium-text">Add New Goal</h1>

                        <form action="<?= base_url('goals/create') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>
                            <input type="hidden" name="id" value="<?= $organization['id'] ?>">

                            <div class="row">
                                <div class="mb-3 col-12">
                                    <label for="theme_id" class="form-label">Themes</label>
                                    <select name="theme_id" class="form-input">
                                        <option value="">Themes</option>
                                        <?php if (!empty($themes)) : ?>
                                            <?php foreach ($themes as $theme): ?>
                                                <option value="<?= esc($theme['id']) ?>"><?= esc($theme['title']) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('theme_id') : '' ?></p>
                                </div>

                                <div class="mb-3 col-12"><label for="type" class="form-label">Strategy Framework Perspectives<small class="text-muted">(Optional)</small></label>
                                    <select name="bscperspective_id" class="form-input">
                                        <option value="">Strategy Framework Perspectives</option>
                                        <?php if (!empty($bscperspectives)) : ?>
                                            <?php foreach ($bscperspectives as $bscperspective): ?>
                                                <option value="<?= esc($bscperspective['id']) ?>"><?= esc($bscperspective['name']) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('bscperspective_id') : '' ?></p>
                                </div>

                                <div class="mb-3 col-12">
                                    <label for="description" class="form-label">Goal Description</label>
                                    <textarea name="description" id="description" rows="4" class="form-input"><?= set_value('description') ?></textarea>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('description') : '' ?></p>
                                </div>
                            </div>
                            <button class="btn btn-pink w-100" x-ref="btn">Add Goal</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>