<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('goals') ?>">Goals</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Goals -->

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('goals?action=download') ?>" class="btn btn-sm" target="_blank">Export Goals</a>
                </div>
                <div class="card recent-sales">

                    <div class="filter text-end">
                        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                            <li class="dropdown-header text-start">
                                <h6>Filter</h6>
                            </li>

                            <li><a class="dropdown-item" href="<?= base_url('goals?status=completed') ?>">Completed</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('goals?status=active') ?>">Active</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('goals?status=inactive') ?>">Inactive</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('goals?status=due') ?>">Behind Schedule</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('goals') ?>">Show All</a></li>

                        </ul>
                    </div>

                    <?php if (!empty($organization)) : ?>
                        <div class="card-body">
                            <h5 class="card-title large-text">High Level Goals
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                    <span>| <a href="<?= base_url('goals/create') ?>" class="btn btn-sm text-primary">Add new</a></span>
                                <?php endif; ?>
                            </h5>
                        <?php endif; ?>
                        <?php if (!empty($goals)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Strategy Framework Perspective</th>
                                        <th scope="col" class="text-bg-secondary">Theme</th>
                                        <th scope="col" class="text-bg-secondary">Goal</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                            <th scope="col" class="text-bg-secondary">Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($goals as $goal) : ?>
                                        <?php
                                        /*
                                        $statusColor = '';
                                        if ($goal['status'] === 'active') {
                                            $statusColor = 'text-bg-primary';
                                        }

                                        if ($goal['status'] === 'completed') {
                                            $statusColor = 'text-bg-secondary';
                                        }

                                        if ($goal['status'] === 'inactive') {
                                            $statusColor = 'text-bg-dark';
                                        } */
                                        ?>
                                        <tr>
                                            <td><?= esc($goal['bscbscperspective_name']) ?></td>
                                            <td><?= esc($goal['theme_name']) ?></td>
                                            <td><?= esc($goal['description']) ?></td>
                                            <td><span class="badge text-bg-dark"><?= esc($goal['status']) ?></span></td>
                                            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">

                                                            <a href="<?= base_url('update/goals/' . $goal['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                            </a>
                                                            <?php if ($goal['status'] === 'active') : ?>
                                                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                    <form action="<?= base_url('goals/disable/' . esc($goal['id'])) ?>" method="post" style="display:inline;">
                                                                        <?= csrf_field() ?>

                                                                        <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                            <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                        </button>
                                                                    </form>
                                                                <?php endif; ?>

                                                            <?php else: ?>
                                                                <form action="<?= base_url('goals/enable/' . esc($goal['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>

                                                            <div class="dropdown">
                                                                <button class="badge text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                    more
                                                                </button>
                                                                <ul class="dropdown-menu">

                                                                    <li><a class="dropdown-item" href="<?= base_url('goal/' . $goal['slug'] . '/initiatives') ?>"><i class="fa fa-expand"></i> Initiatives</a></li>

                                                                    <?php if ($goal['status'] !== 'completed') : ?>
                                                                        <form action="<?= base_url('goals/' . esc($goal['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                                            <?= csrf_field() ?>

                                                                            <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                                                <i class='fa fa-check-circle'></i> Mark Complete
                                                                            </button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>

                        </div>
                    <?php else : ?>
                        <div class="alert alert-info">No goals found</div>

                    <?php endif; ?>
                </div>
            </div><!-- end Goals -->
        </div>
    </section>
</main>

<?= $this->endSection() ?>