<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>S-Tracker</title>
    <meta name="description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta content="Strategy, Performance, Management, Learning, Impact, Model" name="keywords">

    <!-- Favicons -->
    <link rel="shortcut icon" href="<?= base_url('favicon.png') ?>" type="image/png">
    <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

    <meta property="og:url" content="<?= base_url('/') ?>">
    <meta property="og:type" content="Page" />
    <meta property="og:title" content="S-Tracker | Learning Impact Model">
    <meta property="og:description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta property="og:image" content="<?= base_url('assets2/stracker_images/image3.jpg') ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?= base_url('assets2/vendor/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/bootstrap-icons/bootstrap-icons.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/aos/aos.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/glightbox/css/glightbox.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.css') ?>" rel="stylesheet">
    <!-- toastr alert -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- apine js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Main CSS File -->
    <link href="<?= base_url('assets2/css/main.css') ?>" rel="stylesheet">
</head>

<body class="index-page">

    <header id="header" class="header d-flex align-items-center fixed-top">
        <div class="container position-relative d-flex align-items-center justify-content-between">

            <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center me-auto me-xl-0">
                <!-- Uncomment the line below if you also wish to use an image logo -->
                <img src="<?= session()->has('logo') ? base_url(session()->get('logo')) : base_url('assets/favicon.png') ?>" alt="S-Tracker">
                <!-- <h1 class="sitename">S-Tracker</h1> -->
            </a>

            <nav id="navmenu" class="navmenu">
                <ul>
                    <li><a href="<?= base_url('/') ?>" class="active">Home</a></li>
                    <li><a href="#about">About</a></li>
                    <li><a href="#features">Why Strategy Fails</a></li>
                    <li><a href="#pricing">Pricing</a></li>

                    <li><a href="#faq">FAQs</a></li>
                    <li><a href="<?= base_url('contact') ?>">Contact</a></li>
                    <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                </ul>
                <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
            </nav>

            <a class="btn-getstarted" href="<?= base_url('contact') ?>">Book Demo</a>

        </div>
    </header>

    <main class="main">

        <!-- Hero Section -->
        <section id="hero" class="hero section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row align-items-center">

                    <div class="col-lg-6 order-2 order-lg-1" data-aos="fade-right" data-aos-delay="200">
                        <div class="hero-content">
                            <h1 class="hero-title">Strategy Execution & Management</h1>
                            <p class="hero-description">S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs).</p>
                            <div class="hero-actions">
                                <a class="btn btn-success" href="<?= base_url("contact") ?>">Contact Us</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 order-1 order-lg-2" data-aos="fade-left" data-aos-delay="300">
                        <div class="hero-visual">
                            <div class="hero-image-wrapper">
                                <img src="<?= base_url('assets2/img/illustration/illustration-15.webp') ?>" class="img-fluid hero-image" alt="Hero Image">
                                <div class="floating-elements">
                                    <div class="floating-card card-1">
                                        <i class="bi bi-lightbulb"></i>
                                        <span>Discipline</span>
                                    </div>
                                    <div class="floating-card card-2">
                                        <i class="bi bi-award"></i>
                                        <span>Accountability</span>
                                    </div>
                                    <div class="floating-card card-3">
                                        <i class="bi bi-people"></i>
                                        <span>Transparency</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </section><!-- /Hero Section -->
        <!-- /Hero Section -->

        <!-- About Section -->
        <section id="about" class="about section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row gy-5">

                    <div class="col-lg-6" data-aos="fade-right" data-aos-delay="200">
                        <div class="content-wrapper">
                            <div class="section-header">
                                <span class="section-badge">ABOUT S-TRACKER</span>
                                <!-- <h2>Aligning Strategy with Performance</h2> -->
                            </div>

                            <p class="lead-text">The S-Tracker is a strategy management application that helps
                                organizations to translate their strategy into actions and results.</p>

                            <p class="description-text">It addresses the critical strategy execution gap by capturing
                                strategic goals, initiatives and expectations, tracking them; and
                                providing the opportunity for updates and reporting on these
                                initiatives and goals.</p>

                            <p class="description-text">The S-Tracker is about disciplined execution, accountability
                                and transparency that are the hallmark of effective strategy
                                execution.</p>

                            <div class="stats-grid">
                                <div class="stat-item">
                                    <div class="stat-number">7 to 12</div>
                                    <div class="stat-label">Strategic Themes Supported</div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-number">Email</div>
                                    <div class="stat-label">Updates/Reminders</div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-number">100%</div>
                                    <div class="stat-label">Evidence-based Reporting</div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-number">Real-time</div>
                                    <div class="stat-label">Dashboards & Reports</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6" data-aos="fade-left" data-aos-delay="300">
                        <div class="visual-section">
                            <div class="main-image-container">
                                <img src="<?= base_url('assets2/stracker_images/image3.jpg') ?>" alt="Professional team collaboration" class="img-fluid main-visual">
                                <div class="overlay-card">
                                    <div class="card-content">
                                        <h4>Strategy in Action</h4>
                                        <p>S-Tracker bridges the gap between planning and execution with clear goals, KPIs, and evidence-based reporting.</p>
                                        <div class="card-icon">
                                            <i class="bi bi-award-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="secondary-images">
                                <div class="row g-3">
                                    <div class="col-6">
                                        <img src="<?= base_url('assets2/stracker_images/image1.jpg') ?>" alt="Team meeting" class="img-fluid secondary-img">
                                    </div>
                                    <div class="col-6">
                                        <img src="<?= base_url('assets2/stracker_images/image2.jpg') ?>" alt="Office workspace" class="img-fluid secondary-img">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </section><!-- /About Section -->


        <!-- Features Section -->
        <section id="features" class="features section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="tabs-wrapper">

                    <div class="tab-content" data-aos="fade-up" data-aos-delay="200">

                        <div class="tab-pane fade active show" id="features-tab-1">
                            <div class="row align-items-center">

                                <div class="col-lg-5">
                                    <div class="content-wrapper">
                                        <div class="icon-badge">
                                            <i class="bi bi-rocket-takeoff"></i>
                                        </div>
                                        <h3>Why Strategy Fails</h3>

                                        <div class="feature-grid">
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Disconnect between strategy and execution </span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Siloed planning process across departments</span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Lack of real-time visibility into performance</span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Poor documentation,accountability and tracking</span></div>
                                        </div>

                                        <!-- <a href="#" class="btn-primary">Learn More <i class="bi bi-arrow-right"></i></a> -->
                                    </div>
                                </div>

                                <div class="col-lg-7">
                                    <div class="visual-content">
                                        <div class="main-image">
                                            <img src="<?= base_url('assets2/img/execution.webp') ?>" alt="" class="main-img">
                                            <!-- <div class="floating-card">
                                                <i class="bi bi-graph-up-arrow"></i>
                                                <div class="card-content">
                                                    <span>Alignment</span>
                                                    <strong>Seamless Execution</strong>
                                                </div>
                                            </div> -->
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div><!-- End tab content item -->

                        <div class="tab-pane fade" id="features-tab-4">
                            <div class="row align-items-center">

                                <div class="col-lg-5">
                                    <div class="content-wrapper">
                                        <div class="icon-badge">
                                            <i class="bi bi-heart-pulse"></i>
                                        </div>
                                        <h3>Dedicated Support</h3>
                                        <p>Our team provides round-the-clock support, tailored onboarding, and expert consulting to ensure your strategy execution is always on course.</p>

                                        <div class="feature-grid">
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>24/7 assistance</span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Training & onboarding</span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Dedicated strategy consultants</span></div>
                                            <div class="feature-item"><i class="bi bi-check-circle-fill"></i><span>Continuous improvement support</span></div>
                                        </div>

                                        <div class="stats-row">
                                            <div class="stat-item">
                                                <div class="stat-number">24/7</div>
                                                <div class="stat-label">Availability</div>
                                            </div>
                                            <div class="stat-item">
                                                <div class="stat-number">2min</div>
                                                <div class="stat-label">Avg Response Time</div>
                                            </div>
                                            <div class="stat-item">
                                                <div class="stat-number">100%</div>
                                                <div class="stat-label">Client-Focused</div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-lg-7">
                                    <div class="visual-content">
                                        <div class="main-image">
                                            <img src="<?= base_url('assets2/img/features/features-1.webp') ?>" alt="" class="img-fluid">
                                            <div class="floating-card">
                                                <i class="bi bi-headset"></i>
                                                <div class="card-content">
                                                    <span>Support</span>
                                                    <strong>Always Here</strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div><!-- End tab content item -->

                    </div>
                </div>

            </div>

        </section><!-- /Features Section -->

        <!-- Services Section -->
        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <span class="description-title">Who Should Use the S-Tracker?</span>
                <h2>Who Should Use the S-Tracker?</h2>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="services-grid mt-5">
                    <div class="row g-4">
                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>01</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Corporates with Multiple SBUs</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>02</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Organizations with Departments</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>03</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Holding Companies</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>04</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Strategy Consulting Firms</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>05</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Industry & Sector Agnostic</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                            <div class="service-card">
                                <div class="card-number">
                                    <span>06</span>
                                </div>
                                <div class="card-content">
                                    <h5 class="service-title">
                                        <a href="#">Varying Sizes of Organizations</a>
                                    </h5>
                                </div>
                            </div>
                        </div><!-- End Service Card -->

                    </div>
                </div>

            </div>

        </section><!-- /Services Section -->

        <!-- Clients Section -->
        <section id="clients" class="clients section">
            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <span class="description-title">Strategy Development and Implementation Track Record</span>
                <h2>Strategy Development and Implementation Track Record</h2>
            </div><!-- End Section Title -->

            <div class="container">

                <div class="swiper init-swiper">
                    <script type="application/json" class="swiper-config">
                        {
                            "loop": true,
                            "speed": 900,
                            "autoplay": {
                                "delay": 1000
                            },
                            "slidesPerView": "auto",
                            "pagination": {
                                "el": ".swiper-pagination",
                                "type": "bullets",
                                "clickable": true
                            },
                            "breakpoints": {
                                "320": {
                                    "slidesPerView": 2,
                                    "spaceBetween": 40
                                },
                                "480": {
                                    "slidesPerView": 3,
                                    "spaceBetween": 60
                                },
                                "640": {
                                    "slidesPerView": 4,
                                    "spaceBetween": 80
                                },
                                "992": {
                                    "slidesPerView": 6,
                                    "spaceBetween": 120
                                }
                            }
                        }
                    </script>
                    <div class="swiper-wrapper align-items-center">
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/stanbic_bank.png') ?>" class="img-fluid" alt=""></div>
                        
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/firs.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/first_bank.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/cac.jpg') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/abuja_investment_company.jpg') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/fbn_quest.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/fcmb.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/Modern_Shelter.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/nexim_bank.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/oak_pensions.jpg') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/pal_pensions.png') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/ptad.jpg') ?>" class="img-fluid" alt=""></div>
                        <div class="swiper-slide"><img src="<?= base_url('assets2/clients/veritas_pensions.png') ?>" class="img-fluid" alt=""></div>
                        
                    </div>
                </div>

            </div>

        </section><!-- /Clients Section -->

        <!-- Pricing Section -->
<section id="pricing" class="pricing section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <span class="description-title">Pricing</span>
    <h2>Pricing</h2>
    <!-- <p>Choose the plan that matches your organisation size and needs.</p> -->
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">

    <div class="table-responsive">
      <table class="table table-bordered table-success table-hover table-striped text-center align-middle">
        <thead class="table-dark">
          <tr>
            <th>Plan</th>
            <th>Maximum Number of Users</th>
            <th>Annual Subscription (₦)</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>Starter</td>
            <td>Small teams — up to 10 users</td>
            <td>
              <a href="<?= base_url('contact') ?>" class="btn btn-success">CALL</a>
            </td>
          </tr>
          <tr>
            <td>Growth</td>
            <td>Scale confidently — up to 20 users</td>
            <td>
              <a href="<?= base_url('contact') ?>" class="btn btn-success">CALL</a>
            </td>
          </tr>
          <tr>
            <td>Enterprise</td>
            <td>Advanced — up to 50 users</td>
            <td>
              <a href="<?= base_url('contact') ?>" class="btn btn-success">CALL</a>
            </td>
          </tr>
          <tr>
            <td>Corporate</td>
            <td>Corporate — up to 100+ users</td>
            <td>
              <a href="<?= base_url('contact') ?>" class="btn btn-success">CALL</a>
            </td>
          </tr>
        </tbody>
      </table>
      <a href="<?= base_url('contact') ?>" class="btn btn-success">Book Demo<i class="bi bi-arrow-right"></i></a>
    </div>

  </div><!-- End container -->

</section><!-- /Pricing Section -->



        <!-- Faq Section -->
        <section id="faq" class="faq section">

            <div class="container">

                <div class="row justify-content-center">

                    <div class="col-lg-10" data-aos="fade-up" data-aos-delay="100">

                        <div class="faq-container">

                            <div class="faq-item faq-active">
                                <h3>How does S-Tracker help ensure I never miss a deadline?</h3>
                                <div class="faq-content">
                                    <p>S-Tracker automatically sends email reminders to initiative and KPI owners as deadlines approach. You can also sync tasks and milestones directly with your Google Calendar, so every important date is always visible and tracked.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                            <div class="faq-item">
                                <h3>Can I collaborate with colleagues inside the platform?</h3>
                                <div class="faq-content">
                                    <p>Yes. S-Tracker includes built-in chat functionality, enabling teams to communicate directly within the platform. This ensures that discussions, clarifications, and updates happen in the same space where initiatives and KPIs are tracked.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                            <div class="faq-item">
                                <h3>Does S-Tracker support evidence-based reporting?</h3>
                                <div class="faq-content">
                                    <p>Absolutely. Users can attach supporting documents, reports, and other evidence to KPIs or initiatives. This feature makes audits, reviews, and performance validation straightforward and transparent.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                            <div class="faq-item">
                                <h3>What kind of insights do I get from dashboards?</h3>
                                <div class="faq-content">
                                    <p>Dashboards display real-time progress across initiatives and KPIs with RAG (Red-Amber-Green) indicators, charts, and performance summaries. This allows leaders and teams to quickly identify risks, bottlenecks, and achievements.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                            <div class="faq-item">
                                <h3>Can I customize reports for management or board reviews?</h3>
                                <div class="faq-content">
                                    <p>Yes. S-Tracker provides export-ready reports that can be customized by department, initiative, or KPI. Reports can be downloaded in multiple formats and are designed to support board-level presentations and executive reviews.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                            <div class="faq-item">
                                <h3>Is my data secure within S-Tracker?</h3>
                                <div class="faq-content">
                                    <p>S-Tracker is built with enterprise-grade security, including role-based access control, encryption, and full audit trails. This ensures sensitive strategy data is protected and compliant with organizational policies and international standards.</p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                        </div>

                    </div><!-- End Faq Column-->

                </div>

            </div>

        </section><!-- /Faq Section -->


        <!-- Contact Section -->
        <section id="contact" class="contact section light-background">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <span class="description-title">Contact</span>
                <h2>Get in Touch</h2>
                <p>We’d love to hear from you. Whether you’re exploring S-Tracker for your organization, need product support, or want to partner with us — our team is ready to help.</p>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row g-5">
                    <div class="col-lg-6">
                        <div class="content" data-aos="fade-up" data-aos-delay="200">
                            <div class="section-category mb-3">Contact Us</div>
                            <h2 class="display-5 mb-4">Let’s Start the Conversation</h2>
                            <p class="lead mb-4">Reach out for inquiries, demo requests, or support. We’ll get back to you as quickly as possible.</p>

                            <div class="contact-info mt-5">
                                <div class="info-item d-flex mb-3" data-aos="fade-up" data-aos-delay="300">
                                    <i class="bi bi-envelope-at me-3"></i>
                                    <span>info@learningimpactmodel.com</span>
                                </div>

                                <div class="info-item d-flex mb-3" data-aos="fade-up" data-aos-delay="400">
                  <a href="https://wa.me/2348181956161" target="_blank" rel="noopener" class="text-decoration-none">
                      <i class="bi bi-whatsapp me-3"></i>
                      <span>+234 818 195 6161</span></a>
                                </div>

                                <div class="info-item d-flex mb-4">
                                    <i class="bi bi-geo-alt me-3"></i>
                                    <span>Suite 3F4, Katu Koma Plaza, 52 Off Oladipo Diya Way, Sector Centre C, Abuja, FCT, Nigeria</span>
                                </div>
                                <div class="info-item d-flex mb-4">
                                    
                    <a class="btn btn-success" href="<?= base_url("contact") ?>">Contact Us</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3940.5819852847226!2d7.457690473143711!3d9.010555389281235!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x104e0d9d3cd6095b%3A0xe5b9b289c3c890e7!2sKatu%20Koma%20Plaza!5e0!3m2!1sen!2sng!4v1758555905965!5m2!1sen!2sng" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>

                </div>

            </div>

        </section><!-- /Contact Section -->


    </main>

    <footer id="footer" class="footer position-relative dark-background">

        <div class="container footer-top">
            <div class="row gy-4">
                <div class="col-lg-5 col-md-12 footer-about">
                    <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center">
                        <span class="sitename">S-Tracker</span>
                    </a>
                    <p>
                        S-Tracker helps organizations design, track, and achieve their strategic goals.
                        Built on the Balanced Scorecard framework, it empowers leaders to align initiatives,
                        assign ownership, and monitor execution with clarity and accountability.
                    </p>
                    <div class="social-links d-flex mt-4">
                        <!-- <a href=""><i class="bi bi-twitter-x"></i></a> -->
                        <a href="https://www.facebook.com/profile.php?id=100093117607351" target="_blank"><i class="bi bi-facebook"></i></a>
                        <a href="https://www.instagram.com/learningimpactmodel/?hl=en" target="_blank"><i class="bi bi-instagram"></i></a>
                        <a href="https://www.linkedin.com/company/bebetterlearningimpactng/" target="_blank"><i class="bi bi-linkedin"></i></a>
                    </div>
                </div>


                <div class="col-lg-2 col-6 footer-links">
                    <h4>Useful Links</h4>
                    <ul>
                        <li><a href="<?= base_url('/') ?>">Home</a></li>
                        <li><a href="#about">About us</a></li>
                        <li><a href="#features">Why Strategy Fails</a></li>
                        <!--<li><a href="#services">Services</a></li>-->
                        <li><a href="#pricing">Pricing</a></li>
                        <li><a href="#faq">FAQs</a></li>
                        <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Other Products</h4>
                    <ul>
                        <li><a href="https://onlineefiko.com" target="_blank">Online Efiko</a></li>
                        <li><a href="https://lifeskillsafrica.com" target="_blank">Life Skills Africa</a></li>
                        <li><a href="https://360feedback.com.ng" target="_blank">360 Feedback Solutions</a></li>
                        <li><a href="https://epapervendor.com" target="_blank">Epaper Vendor</a></li>
                        <li><a href="https://ldplanner.efikohr.com/" target="_blank">L&D Planner</a></li>
                        <li><a href="https://prater.efikohr.com/" target="_blank">P-Rater</a></li>
                    </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                    <h4>Contact Us</h4>
                    <p>Suite 3F4, Katu Koma Plaza, </p>
                    <p>52 Off Oladipo Diya Way,</p>
                    <p>Sector Centre C, Abuja, FCT, Nigeria.</p>
                    <p class="mt-4"><strong>WhatsApp:</strong><a href="https://wa.me/2348181956161" target="_blank" rel="noopener" class="text-decoration-none">
                      <i class="bi bi-whatsapp me-3"></i>
                      <span>+234 818 195 6161</span></a></p>
                    <p><strong>Email:</strong> <span>info@learninigimpactmodel.com</span></p>
                </div>

            </div>
        </div>
        <div class="container copyright text-center mt-4">
            <p>
                © <span id="year"></span> <span>Copyright</span>
                <strong class="px-1 sitename">S-Tracker</strong>
                <span>All Rights Reserved</span>
            </p>
            <div class="credits">
                Designed by <a href="https://learningimpactmodel.com/" target="_blank">Learning Impact Model</a>
            </div>
        </div>

        <script>
            document.getElementById("year").textContent = new Date().getFullYear();
        </script>


    </footer>

    <!-- Scroll Top -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="<?= base_url('assets2/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/php-email-form/validate.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/aos/aos.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/glightbox/js/glightbox.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/purecounter/purecounter_vanilla.js') ?>"></script>
    <!-- toastr alert -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- apine js -->
    <script src="<?= base_url('assets/js/apine.js') ?>"></script>

    <!-- Main JS File -->
    <script src="<?= base_url('assets2/js/main.js') ?>"></script>
    <?= $this->include('components/alert') ?>

</body>

</html>