<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>
<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <?php if (!empty($initiative)) : ?>
                        <li class="breadcrumb-item"><?= word_limiter($initiative['name'], 5) ?></a></li>
                        <li class="breadcrumb-item active"><a href="#">Assign Owner</a></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for assigning initiatives to owners -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->
            <div class="col-8">
                <div class="card recent-sales overflow-auto">
                    <?php if (!empty($initiative)) : ?>
                        <div class="card-body">
                            <h5 class="card-title medium-text text-center"> <span class="text-muted">Assign owner of</span> <?= $initiative['name'] ?></h5>

                            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                <form action="<?= base_url('initiatives/' . esc($initiative['slug']) . '/owner/assign') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                    <?= csrf_field() ?>
                                    <input type="hidden" value="<?= $initiative['id'] ?>" name="id">

                                    <div class="row">

                                        <div class="mb-1 col-12">
                                            <label for="owner_type" class="form-label">Type of Owner</label>
                                            <select name="owner_type" class="form-input">
                                                <option value="">Choose owner type</option>
                                                <option value="organizationstructure_owner">SBU/Department/Unit</option>
                                                <option value="individual_owner">Individual</option>
                                            </select>
                                            <p class="text-danger mt-1"><?= isset($validation) ? $validation->showError('initiative_id') : '' ?></p>
                                        </div>

                                        <div class="mb-1 col-12" id="organizationstructure_owner">
                                            <label for="organizationstructure_owner_id" class="form-label">SBU/Department/Unit</label>
                                            <select name="organizationstructure_owner_id" class="form-input">
                                                <option value="">Choose SBU/Department/Unit</option>
                                                <?php if (!empty($structures)) : ?>
                                                    <?php foreach ($structures as $structure) : ?>
                                                        <option value="<?= $structure['id'] ?>"><?= $structure['name'] ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                            <p class="text-danger mt-1"><?= isset($validation) ? $validation->showError('dummy_field') : '' ?></p>
                                        </div>

                                        <div class="mb-1 col-12" id="individual_owner">
                                            <label for="individual_owner_id" class="form-label">Users</label>
                                            <select name="individual_owner_id" class="form-input">
                                                <option value="">Choose user</option>
                                                <?php if (!empty($users)) : ?>
                                                    <?php foreach ($users as $user) : ?>
                                                        <option value="<?= $user['id'] ?>"><?= $user['name'] ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                            <p class="text-danger mt-1"><?= isset($validation) ? $validation->showError('dummy_field') : '' ?></p>
                                        </div>
                                    </div>

                                    <?php if (isset($Error)) : ?>

                                        <p class="text-danger mb-3 medium-text text-center"> <?= $Error ?> </p>

                                    <?php endif; ?>

                                    <button class="btn btn-pink w-100" x-ref="btn">Save</button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>