<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <?php if (!empty($goal)) : ?>
                        <li class="breadcrumb-item"><?= word_limiter($goal['description'], 7) ?></a></li>
                        <li class="breadcrumb-item active"><a href="#">New</a></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-8">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h5 class="card-title medium-text text-center">Add Initiative</h5>


                        <!-- add intiatives pane -->
                        <?php if (in_array(session()->get('role'), ['admin', 'chief_strategy_officer', 'superadmin'])): ?>
                            <form action="<?= base_url('initiatives/create') ?>" method="post" class="p-4" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                <?= csrf_field() ?>
                                <input type="hidden" value="<?= $goal['id'] ?>" name="id">

                                <div class="row">

                                    <div class="mb-1 col-12">
                                        <label for="name" class="form-label">Initiative</label>
                                        <textarea name="name" class="form-input" rows="5"><?= set_value('name') ?></textarea>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="target" class="form-label">Target</label>
                                        <input type="text" class="form-input" value="<?= set_value('target') ?>" name="target">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('target') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="measure_of_success" class="form-label">Measure of success</label>
                                        <select name="measure_of_success" class="form-input">
                                            <option value="">Choose measure of success</option>
                                            <option value="time" <?= set_value('measure_of_success') === 'time' ? 'selected' : '' ?>>Time</option>
                                            <option value="budget" <?= set_value('measure_of_success') === 'budget' ? 'selected' : '' ?>>Budget</option>
                                            <option value="quality" <?= set_value('measure_of_success') === 'quality' ? 'selected' : '' ?>>Quality</option>
                                        </select>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('measure_of_success') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="start_date" class="form-label">Start Date</label>
                                        <input type="date" class="form-input" value="<?= set_value('start_date') ?>" name="start_date">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('start_date') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="end_date" class="form-label">Expected date of completion</label>
                                        <input type="date" class="form-control" value="<?= set_value('end_date') ?>" name="end_date">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('end_date') : '' ?></p>
                                    </div>
                                </div>

                                <button class="btn btn-pink w-100" x-ref="btn">Save</button>
                            </form>

                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>