<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <li class="breadcrumb-item active"><a href="#">Update</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-8">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                            <h4 class="card-title medium-text">Update Initiative</h4>
                            <form action="<?= base_url('initiatives/update/' . esc($initiative['slug'])) ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                <?= csrf_field() ?>
                                <input type="hidden" value="PUT" name="_method">
                                <input type="hidden" value="<?= $initiative['id'] ?>" name="id">

                                <div class="row">

                                    <div class="mb-1 col-12">
                                        <label for="name" class="form-label">Initiative</label>
                                        <textarea name="name" class="form-input" rows="5"><?= $initiative['name'] ?></textarea>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="target" class="form-label">Target</label>
                                        <input type="text" class="form-input" value="<?= $initiative['target'] ?>" name="target">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('target') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="measure_of_success" class="form-label">Measure of success</label>
                                        <select name="measure_of_success" class="form-input">
                                            <option value="">Choose measure of success</option>
                                            <option value="time" <?= $initiative['measure_of_success'] === 'time' ? 'selected' : '' ?>>Time</option>
                                            <option value="budget" <?= $initiative['measure_of_success'] === 'budget' ? 'selected' : '' ?>>Budget</option>
                                            <option value="quality" <?= $initiative['measure_of_success'] === 'quality' ? 'selected' : '' ?>>Quality</option>
                                        </select>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('measure_of_success') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="start_date" class="form-label">Start Date</label>
                                        <input type="date" class="form-input" value="<?= $initiative['start_date'] ?>" name="start_date">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('start_date') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-6">
                                        <label for="end_date" class="form-label">Expected date of completion</label>
                                        <input type="date" class="form-input" value="<?= $initiative['end_date'] ?>" name="end_date">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('end_date') : '' ?></p>
                                    </div>
                                </div>

                                <button class="btn btn-pink w-100" x-ref="btn">Update</button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<?= $this->endSection() ?>