<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <?php if (!empty($goal)) : ?>
                        <li class="breadcrumb-item"><?= word_limiter($goal['description'], 7) ?></a></li>
                        <li class="breadcrumb-item active"><a href="#">Initiatives</a></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('goal/' . $goal['slug'] . '/initiatives?action=download') ?>" class="btn btn-sm" target="_blank">Export Initiatives</a>
                </div>
                <!-- loop out the initiatives if available -->
                <div class="card">
                    <div class="card-body">
                        <h4 class="large-text card-title">Initiatives
                            <span>
                                <a href="<?= base_url('goal/' . $goal['slug'] . '/initiatives/create') ?>" class="btn btn-sm text-primary">Add new</a>
                            </span>
                        </h4>
                    </div>
                </div>
                <?php if (!empty($initiatives)) : ?>
                    <div class="row">
                        <?php foreach ($initiatives as $initiative) : ?>
                            <?php
                            // set appropriate rag_status

                            $color = '';

                            $endDate = new DateTime($initiative['end_date']);
                            $now = new DateTime();

                            if ($endDate < $now) {
                                $color = 'spinner-grow text-danger';
                            } elseif ($initiative['rag_status'] == 'amber') {
                                $color = 'spinner-grow text-warning';
                            } elseif($endDate > $now && $initiative['status'] === 'active') {
                                $color = "spinner-grow text-warning";
                            }elseif($initiative['status'] === 'completed'){
                                $color = "spinner-grow text-success";
                            }
                            ?>


                            <?php

                            $statusColor = '';
                            if ($initiative['status'] === 'active') {
                                $statusColor = 'bg-warning';
                            }

                            if ($initiative['status'] === 'completed') {
                                $statusColor = 'bg-success';
                            }

                            if ($initiative['status'] === 'inactive') {
                                $statusColor = 'bg-danger';
                            }
                            ?>

                            <!-- initiatives  -->
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="filter">
                                        <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                            <li>
                                                <a class="dropdown-item text-primary" href="<?= base_url('initiatives/update/' . $initiative['slug']) ?>">
                                                    <i class="fa fa-edit ms-1" style="font-size:15px"></i> Edit
                                                </a>
                                            </li>
                                            <?php if ($initiative['status'] === 'active') : ?>



                                                <form action="<?= base_url('initiative/' . esc($initiative['id']) . '/disable') ?>" method="post" style="display:inline;">
                                                    <?= csrf_field() ?>
                                                    <input type="hidden" name="id" value="<?= esc($goal['id']) ?>">

                                                    <button class="dropdown-item text-danger" title="Deactivate" type="submit">
                                                        <i class="fa fa-power-off" style="font-size:15px"></i> Disable
                                                    </button>
                                                </form>

                                            <?php elseif ($initiative['status'] === 'inactive' || $initiative['status'] === 'completed'): ?>

                                                <form action="<?= base_url('initiative/' . esc($initiative['id']) . '/enable') ?>" method="post" style="display:inline;">
                                                    <?= csrf_field() ?>
                                                    <input type="hidden" name="id" value="<?= esc($goal['id']) ?>">

                                                    <button class="dropdown-item text-warning" title="Activate" type="submit">
                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i> Enable
                                                    </button>
                                                </form>

                                            <?php endif; ?>

                                            <a class="dropdown-item text-primary" href="<?= base_url('initiatives/' . $initiative['slug'] . '/kpis') ?>">
                                                <i class="fa fa-plus-circle"></i>KPIs
                                            </a>

                                            <a class="dropdown-item text-primary" href="<?= base_url('my-initiatives/' . $initiative['slug'] . '/submissions') ?>">
                                                <i class="fa fa-plus-circle"></i>Reports
                                            </a>

                                            <a class="dropdown-item text-primary" href="<?= base_url('initiatives/' . $initiative['slug'] . '/owners') ?>">
                                                <i class="fa fa-user"></i>Owners
                                            </a>

                                            <a class="dropdown-item text-primary" href="<?= base_url('my-initiatives/' . $initiative['slug'] . '/comments') ?>">
                                                <i class="fa fa-comment"></i>Comments
                                            </a>

                                            <?php if ($initiative['status'] !== 'completed') : ?>
                                                <form action="<?= base_url('initiative/' . esc($initiative['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                    <?= csrf_field() ?>
                                                    <input type="hidden" name="id" value="<?= esc($goal['id']) ?>">

                                                    <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                        <i class='fa fa-check-circle'></i> Mark Complete
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </ul>
                                    </div>

                                    <div class="card-body">
                                        <h5 class="card-title medium-text">Initiative: </strong> <?= esc($initiative['name']) ?? '' ?></h5>

                                        <div class="activity">

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>KPIs: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content">
                                                    <?php if (!empty($initiative['kpis'])) : ?>
                                                        <ul class="mb-0 ps-3">
                                                            <?php foreach ($initiative['kpis'] as $kpi) : ?>
                                                                <li><?= esc(ucfirst($kpi)) ?></li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    <?php else : ?>
                                                        -
                                                    <?php endif; ?>
                                                </div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Owners</strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content">
                                                    <?php if (!empty($initiative['owners'])) : ?>
                                                        <ul class="mb-0 ps-3">
                                                            <?php foreach ($initiative['owners'] as $owner) : ?>
                                                                <li><?= esc(ucfirst($owner['name'])) ?></li>
                                                            <?php endforeach; ?>

                                                        </ul>
                                                    <?php else : ?>
                                                        -
                                                    <?php endif; ?>
                                                </div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Target: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content"><?= esc($initiative['target']) ?? '' ?></div>
                                            </div><!-- End initiative item-->


                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Started: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content"><?= (new DateTime($initiative['start_date']))->format('d F, Y') ?></div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Due date: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content"><?= (new DateTime($initiative['end_date']))->format('d F, Y') ?></div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>RAG Status</strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content">
                                                    <div class="<?= $color ?>" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Measure of success: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content"><?= ucfirst(esc($initiative['measure_of_success'])) ?? '' ?></div>
                                            </div><!-- End initiative item-->

                                            <div class="activity-item d-flex">
                                                <div class="activite-label">
                                                    <strong>Status: </strong>
                                                </div>
                                                <i class='bi bi-circle-fill activity-badge text-secondary align-self-start'></i>
                                                <div class="activity-content">
                                                    <span class="badge <?= $statusColor ?>"><?= esc($initiative['status']) ?></span>
                                                </div>
                                            </div><!-- End initiative item-->
                                        </div>

                                    </div>
                                </div><!-- End initiatives  -->
                            </div>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <div class="alert alert-info">No initiatives found for this goal</div>
                    <?php endif; ?>
                    </div>
            </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>