<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('initiatives') ?>">Initiatives</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('initiatives?action=download') ?>" class="btn btn-sm" target="_blank">Export Initiatives</a>
                </div>
                <!-- loop out the initiatives if available -->
                <div class="card">
                    <div class="card-body">

                        <div class="filter text-end">
                            <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                </li>

                                <li><a class="dropdown-item" href="<?= base_url('initiatives?status=completed') ?>">Completed</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('initiatives?status=active') ?>" data-status="active">Active</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('initiatives?status=inactive') ?>" data-status="inactive">Inactive</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('initiatives?status=due') ?>" data-status="inactive">Behind Schedule</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('initiatives') ?>" data-status="all">Show All</a></li>

                            </ul>
                        </div>
                        <h4 class="large-text card-title">Our Initiatives</h4>

                        <?php if (!empty($initiatives)) : ?>
                            <table class="table datatable table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Initiative</th>
                                        <th scope="col" class="text-bg-secondary">Target</th>
                                        <th scope="col" class="text-bg-secondary">Started</th>
                                        <th scope="col" class="text-bg-secondary">Due date</th>
                                        <th scope="col" class="text-bg-secondary">RAG Status</th>
                                        <th scope="col" class="text-bg-secondary">Measure of success</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'chief_strategy_officer'])): ?>
                                            <th scope="col" class="text-bg-secondary">Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($initiatives as $initiative) : ?>
                                        <?php
                                        // set appropriate rag_status

                                        $color = '';

                                        $endDate = new DateTime($initiative['end_date']);
                                        $now = new DateTime();

                                        if ($endDate < $now) {
                                            $color = 'background-color:red';
                                        } 
                                        elseif ($initiative['rag_status'] === 'amber') {
                                            $color = 'background-color:yellow';
                                        } 
                                        elseif ($endDate > $now && $initiative['status'] === 'active') {
                                            $color = 'background-color:yellow';
                                        } 
                                        if ($initiative['status'] === 'completed') {
                                            $color = 'background-color:green';
                                        }
                                        ?>

                                        <?php
                                        /*

                                        $statusColor = '';
                                        if ($initiative['status'] === 'active') {
                                            $statusColor = 'text-bg-info';
                                        }

                                        if ($initiative['status'] === 'completed') {
                                            $statusColor = 'text-bg-secondary';
                                        }

                                        if ($initiative['status'] === 'inactive') {
                                            $statusColor = 'text-bg-dark';
                                        } */
                                        ?>
                                        <tr data-status="<?= esc(strtolower($initiative['status'])) ?>">
                                            <td><?= esc($initiative['name']) ?? '' ?></td>
                                            <td><?= esc($initiative['target']) ?? '' ?></td>
                                            <td><?= (new DateTime($initiative['start_date']))->format('d F, Y') ?></td>
                                            <td><?= (new DateTime($initiative['end_date']))->format('d F, Y') ?></td>
                                            <td style="<?= $color ?>"></td>
                                            <td><?= ucfirst(esc($initiative['measure_of_success'])) ?? '' ?></td>
                                            <td>
                                                <span class="badge text-bg-dark"><?= esc($initiative['status']) ?></span>
                                            </td>
                                            <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'chief_strategy_officer'])): ?>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">

                                                            <div class="dropdown">
                                                                <button class="badge text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                    more
                                                                </button>
                                                                <ul class="dropdown-menu">


                                                                    <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                        <a href="<?= base_url('initiatives/update/' . $initiative['slug']) ?>" class="dropdown-item text-success" title="Edit">
                                                                            <i class="fa fa-edit ms-1" style="font-size:15px"></i> Edit
                                                                        </a>
                                                                        <?php if ($initiative['status'] === 'active') : ?>
                                                                            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                                <form action="<?= base_url('initiative/' . esc($initiative['id'] . '/disable')) ?>" method="post" style="display:inline;">
                                                                                    <?= csrf_field() ?>

                                                                                    <button class="dropdown-item text-danger" title="Deactivate" type="submit">
                                                                                        <i class="fa fa-power-off" style="font-size:15px"></i> Disable
                                                                                    </button>
                                                                                </form>
                                                                            <?php endif; ?>

                                                                        <?php else: ?>
                                                                            <form action="<?= base_url('initiative/' . esc($initiative['id'] . '/enable')) ?>" method="post" style="display:inline;">
                                                                                <?= csrf_field() ?>

                                                                                <button class="dropdown-item text-warning" title="Activate" type="submit">
                                                                                    <i class="fa fa-toggle-on" style="font-size:15px"></i> Enable
                                                                                </button>
                                                                            </form>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>

                                                                    <li><a class="dropdown-item" href="<?= base_url('initiatives/' . $initiative['slug'] . '/owners') ?>"><i class="fa fa-user"></i>Owners</a></li>
                                                                    <li><a class="dropdown-item" href="<?= base_url('my-initiatives/' . $initiative['slug'] . '/submissions') ?>"><i class="fa fa-plus-circle"></i>Reports</a></li>
                                                                    <li><a class="dropdown-item" href="<?= base_url('initiatives/' . $initiative['slug'] . '/kpis') ?>"><i class="fa fa-plus-circle"></i>KPIs</a></li>
                                                                    <li><a class="dropdown-item" href="<?= base_url('my-initiatives/' . $initiative['slug'] . '/comments') ?>"><i class="fa fa-comment"></i>Comments</a></li>

                                                                    <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                        <?php if ($initiative['status'] !== 'completed') : ?>
                                                                            <form action="<?= base_url('initiative/' . esc($initiative['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                                                <?= csrf_field() ?>

                                                                                <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                                                    <i class='fa fa-check-circle'></i> Mark Complete
                                                                                </button>
                                                                            </form>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                        <?php else: ?>
                            <div class="alert alert-info">No initiatives found</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>