<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <li class="breadcrumb-item active"><a href="#">Owners</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Goals -->

            <div class="col-9">
                <div class="card recent-sales">

                    <?php if (!empty($initiative)) : ?>
                        <div class="card-body">
                            <h5 class="card-title large-text">Initiative Owners
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                    <span>| <a href="<?= base_url('initiatives/' . esc($initiative['slug']) . '/owner/assign') ?>" class="btn btn-sm text-primary">Assign Owner</a></span>
                                <?php endif; ?>
                            </h5>
                        <?php endif; ?>
                        <?php if (!empty($owners)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Name</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                            <th scope="col" class="text-bg-secondary">Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($owners as $owner) : ?>
                                        <tr>
                                            <td><?= esc($owner['owner_name']) ?></td>
                                            <td><span class="badge <?= esc($owner['status']) === 'active' ? 'bg-success' : 'bg-danger' ?>"><?= esc($owner['status']) ?></span></td>
                                            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">

                                                            <?php if ($owner['status'] === 'active') : ?>

                                                                <form action="<?= base_url('initiatives/'  . esc($owner['id']) . '/owner/disable') ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                        <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php else: ?>
                                                                <form action="<?= base_url('initiatives/'  . esc($owner['id']) . '/owner/enable') ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php endif; ?>
                                                        </div>
                                                    </div>

                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>

                        </div>
                    <?php else : ?>
                        <div class="alert alert-info">No owners found for this initiative</div>

                    <?php endif; ?>
                </div>
            </div><!-- end initiative owners -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>