<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <li class="breadcrumb-item active"><a href="#">Reports</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Goals -->

            <div class="col-12">
                <div class="card recent-sales">


                    <div class="card-body">

                        <h5 class="card-title large-text">Initiative Report details</h5>
                        <?php if (!empty($report)) : ?>
                            <h2 class="medium-text">Comment</h2>
                            <p>
                                <?= html_entity_decode($report['submitted_comment']) ?>
                            </p>

                            <?php if (isset($report['percentage_of_completion'])): ?>
                                <h2 class="medium-text mt-4">Percentage Completion</h2>
                                <div class="progress" style="height: 25px;">
                                    <div
                                        class="progress-bar bg-success"
                                        role="progressbar"
                                        style="width: <?= esc($report['percentage_of_completion']) ?>%;"
                                        aria-valuenow="<?= esc($report['percentage_of_completion']) ?>"
                                        aria-valuemin="0"
                                        aria-valuemax="100">
                                        <?= esc($report['percentage_of_completion']) ?>%
                                    </div>
                                </div>
                            <?php endif; ?>


                            <?php if ($report['document_link'] !== null): ?>
                                <h2 class="medium-text">Document</h2>

                                <?php
                                $fileLink = base_url($report['document_link']);
                                $extension = strtolower(pathinfo($fileLink, PATHINFO_EXTENSION));
                                ?>

                                <?php if (in_array($extension, ['jpg', 'jpeg', 'png'])): ?>
                                    <img src="<?= esc($fileLink) ?>" alt="Uploaded Image" style="max-width: 100%; height: auto; border: 1px solid #ccc; margin-top: 10px;">
                                <?php elseif ($extension === 'pdf'): ?>
                                    <iframe src="<?= esc($fileLink) ?>" width="100%" height="600px" style="border: 1px solid #ccc; margin-top: 10px;"></iframe>
                                    <!-- Or alternatively: <a href="fileLink" target="_blank">Open PDF</a> -->
                                <?php else: ?>
                                    <p>Unsupported file type.</p>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if ($report['status'] === 'pending') : ?>
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                    <div class="row mt-4 w-50">

                                        <form action="<?= base_url('reports/' . $report['slug'] . '?type=initiative') ?>" method="post" x-data="formSubmit" @submit.prevent="submit">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="initiative_id" value="<?= $report['initiative_id'] ?>">
                                            <input type="hidden" name="report_id" value="<?= $report['id'] ?>">
                                            
                                            <div class="col mb-3">
                                        <label for="approved_percentage_of_completion" class="form-label">Percentage Completion</label>
                                        <input
                                            class="form-range"
                                            type="range"
                                            name="approved_percentage_of_completion"
                                            id="approved_percentage_of_completion"
                                            min="0"
                                            max="100"
                                            step="5"
                                            value="<?= $report['percentage_of_completion'] ?? 0 ?>"
                                            oninput="document.getElementById('percentValue').innerText = this.value + '%';">
                                        <span id="percentValue"><?= $report['percentage_of_completion'] ?? 0 ?> %</span>

                                            <div class="col mb-3">
                                                <label for="action" class="form-label">Action</label>
                                                <select name="action" id="" class="form-input">
                                                    <option value="">Select</option>
                                                    <option value="reject">Reject</option>
                                                    <option value="approve">Approve</option>
                                                    <option value="mark_complete">Mark Complete</option>
                                                </select>
                                                <p class="text-danger"><?= isset($validation) ? $validation->showError('action') : '' ?></p>
                                            </div>

                                            <div class="col mb-3">
                                                <label for="comment" class="form-label">Comment</label>
                                                <textarea name="comment" class="form-input" rows="3"></textarea>
                                                <p class="text-danger"><?= isset($validation) ? $validation->showError('comment') : '' ?></p>
                                            </div>
                                            <button class="btn btn-pink w-100" type="submit" x-ref="btn">Save</button>
                                        </form>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                    </div>
                <?php else : ?>

                    <div class="alert alert-info">Report not found</div>

                <?php endif; ?>
                </div>
            </div>
        </div><!-- end Goals -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>