<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('kpis') ?>">KPIs</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- KPIs from an initiative -->

            <div class="col-12">
                <div class="card recent-sales">

                    
                        <div class="card-body">
                            <h5 class="card-title large-text">KPIs
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                      <button type="button" class="btn btn-sm text-primary" data-bs-toggle="modal" data-bs-target="#verticalycentered">
                                        Upload Bulk KPIs
                                      </button>
                                            <!-- Modal for Bulk Upload -->
                                    <div class="modal fade" id="verticalycentered" tabindex="-1">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Upload Bulk KPIs</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="post" action="<?= base_url('kpis/create/bulk') ?>" class="p-4 mx-auto" enctype="multipart/form-data" id="bulkKpiForm">
                                                        <?= csrf_field() ?>
                                                        
                                                        <div class="mb-3">
                                                            <label for="kpiFile" class="form-label">Select File (CSV or Excel)</label>
                                                            <input class="form-control" type="file" name="kpis" id="kpiFile" accept=".csv,.xls,.xlsx" required />
                                                            <div class="form-text">Supported formats: CSV, XLS, XLSX</div>
                                                        </div>
                                                        
                                                        <button type="submit" class="btn btn-pink w-100" id="uploadBtn">
                                                            <span class="btn-text">Upload</span>
                                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                                        </button>
                                                    </form>
                                                </div>
                                                <div class="modal-footer">
                                                    <a href="<?= base_url('templates/kpis.csv') ?>" download class="btn btn-primary">
                                                        <i class="fa fa-download"></i> Download Template
                                                    </a>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <script>
                                    // Optional: Add loading state to button
                                    document.getElementById('bulkKpiForm')?.addEventListener('submit', function() {
                                        const btn = document.getElementById('uploadBtn');
                                        btn.disabled = true;
                                        btn.querySelector('.btn-text').textContent = 'Uploading...';
                                        btn.querySelector('.spinner-border').classList.remove('d-none');
                                    });
                                    </script>
                                    <!-- End Modal for Bulk Upload -->
                                <?php endif; ?>
                            </h5>
                        
                        <?php if (!empty($kpis)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">KPI</th>
                                        <th scope="col" class="text-bg-secondary">Exp. date of completion</th>
                                        <th scope="col" class="text-bg-secondary">Owners</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($kpis as $kpi) : ?>
                                        <?php
                                        /*
    
                                        $statusColor = '';
                                        if ($kpi['status'] === 'active') {
                                            $statusColor = 'bg-warning';
                                        }

                                        if ($kpi['status'] === 'completed') {
                                            $statusColor = 'bg-success';
                                        }

                                        if ($kpi['status'] === 'inactive') {
                                            $statusColor = 'bg-danger';
                                        } */
                                        ?>
                                        <tr>
                                            <td><?= esc($kpi['name']) ?></td>
                                            <td><?= (new DateTime($kpi['timeline']))->format('d F, Y') ?></td>
                                            <td>
                                                <?php if (!empty($kpi['owners'])) : ?>
                                                    <ul class="mb-0 ps-3">
                                                        <?php foreach ($kpi['owners'] as $owner) : ?>
                                                            <li><?= esc(ucfirst($owner['owner_name'])) ?></li>
                                                        <?php endforeach; ?>

                                                    </ul>
                                                <?php else : ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td><span class="badge text-bg-dark"><?= esc($kpi['status']) ?></span></td>
                                            <td>
                                                <div class="status-actions">
                                                    <div class="actions">

                                                        <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                            <a href="<?= base_url('initiatives/kpi/update/' . $kpi['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                            </a>

                                                            <?php if ($kpi['status'] === 'active') : ?>

                                                                <form action="<?= base_url('kpi/disable/' . esc($kpi['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                        <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php else: ?>
                                                                <form action="<?= base_url('kpi/enable/' . esc($kpi['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                        <div class="dropdown">
                                                            <button class="btn text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                more
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a class="dropdown-item" href="<?= base_url('initiatives/kpi/' . $kpi['slug'] . '/owners') ?>"><i class="fa fa-user-o"></i> Owners</a>
                                                                </li>
                                                                <li><a class="dropdown-item" href="<?= base_url('my-kpis/' . $kpi['slug'] . '/comments') ?>"><i class="fa fa-comment"></i>Comments</a></li>


                                                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                    <?php if ($kpi['status'] !== 'completed') : ?>
                                                                        <form action="<?= base_url('kpi/' . esc($kpi['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                                            <?= csrf_field() ?>

                                                                            <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                                                <i class='fa fa-check-circle'></i> Mark Complete
                                                                            </button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-info">No KPIs found!</div>
                    <?php endif; ?>

                </div>
            </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>