<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>
<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <?php if (!empty($initiative)) : ?>
                        <li class="breadcrumb-item"><a href="#"><?= word_limiter($initiative['name'], 5) ?></a></li>
                        <li class="breadcrumb-item active"><a href="#">KPIs</a></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- KPIs from an initiative -->

            <div class="col-8">
                <div class="card recent-sales">

                    <div class="card-body">
                        <?php if (in_array(session()->get('role'), ['admin', 'chief_strategy_officer', 'superadmin'])): ?>
                            <h4 class="text-center medium-text card-title">Add KPI for <?= $initiative['name'] ?></h4>
                            <form action="<?= base_url('initiatives/' . esc($initiative['slug']) . '/kpi/create') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                <?= csrf_field() ?>
                                <input type="hidden" value="<?= $initiative['id'] ?>" name="id">

                                <div class="row">

                                    <div class="mb-1 col-12">
                                        <label for="name" class="form-label">KPI</label>
                                        <textarea name="name" class="form-input" rows="5"><?= set_value('name') ?></textarea>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-12">
                                        <label for="timeline" class="form-label">Expected date of completion</label>
                                        <input type="date" name="timeline" id="timeline" class="form-input" value="<?= set_value('timeline') ?>">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('timeline') : '' ?></p>
                                    </div>
                                </div>

                                <button class="btn btn-pink w-100" x-ref="btn">Save</button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>