<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('goals') ?>">Goals</a></li>
                    <?php if (!empty($initiative)) : ?>
                        <li class="breadcrumb-item"><a href="#">Initiative</a></li>
                        <li class="breadcrumb-item"><a href="#"><?= word_limiter($initiative['name'], 5) ?></a></li>
                        <li class="breadcrumb-item active"><a href="#">KPIs</a></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- KPIs from an initiative -->

            <div class="col-12">
                <div class="card recent-sales">

                    <?php if (!empty($initiative)) : ?>
                        <div class="card-body">
                            <h5 class="card-title large-text">KPIs
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                    <span>| <a href="<?= base_url('initiatives/' . $initiative['slug'] . '/kpi/create') ?>" class="btn btn-sm text-primary">Add new</a></span>
                                <?php endif; ?>
                            </h5>
                        <?php endif; ?>
                        <?php if (!empty($kpis)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">KPI</th>
                                        <th scope="col" class="text-bg-secondary">Exp. date of completion</th>
                                        <th scope="col" class="text-bg-secondary">Owners</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($kpis as $kpi) : ?>
                                        <?php

                                        $statusColor = '';
                                        if ($kpi['status'] === 'active') {
                                            $statusColor = 'bg-warning';
                                        }

                                        if ($kpi['status'] === 'completed') {
                                            $statusColor = 'bg-success';
                                        }

                                        if ($kpi['status'] === 'inactive') {
                                            $statusColor = 'bg-danger';
                                        }
                                        ?>
                                        <tr>
                                            <td><?= esc($kpi['name']) ?></td>
                                            <td><?= (new DateTime($kpi['timeline']))->format('d F, Y') ?></td>
                                            <td>
                                                <?php if (!empty($kpi['owners'])) : ?>
                                                    <ul class="mb-0 ps-3">
                                                        <?php foreach ($kpi['owners'] as $owner) : ?>
                                                            <li><?= esc(ucfirst($owner['owner_name'])) ?></li>
                                                        <?php endforeach; ?>

                                                    </ul>
                                                <?php else : ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td><span class="badge <?= $statusColor ?>"><?= esc($kpi['status']) ?></span></td>
                                            <td>
                                                <div class="status-actions">
                                                    <div class="actions">

                                                        <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                            <a href="<?= base_url('initiatives/kpi/update/' . $kpi['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                            </a>

                                                            <?php if ($kpi['status'] === 'active') : ?>

                                                                <form action="<?= base_url('kpi/disable/' . esc($kpi['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                        <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php else: ?>
                                                                <form action="<?= base_url('kpi/enable/' . esc($kpi['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                        <div class="dropdown">
                                                            <button class="btn btn-success btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                more
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a class="dropdown-item" href="<?= base_url('initiatives/kpi/' . $kpi['slug'] . '/owners') ?>"><i class="fa fa-user-o"></i> Owners</a>
                                                                </li>
                                                                <li><a class="dropdown-item" href="<?= base_url('my-kpis/' . $kpi['slug'] . '/comments') ?>"><i class="fa fa-comment"></i>Comments</a></li>


                                                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                    <?php if ($kpi['status'] !== 'completed') : ?>
                                                                        <form action="<?= base_url('kpi/' . esc($kpi['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                                            <?= csrf_field() ?>

                                                                            <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                                                <i class='fa fa-check-circle'></i> Mark Complete
                                                                            </button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-info">No KPIs found for this initiative</div>
                    <?php endif; ?>

                </div>
            </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>