<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">KPIs</a></li>
                    <li class="breadcrumb-item active"><a href="#">Reports</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Goals -->

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('reports?type=kpi&status=' . $status . '&action=download') ?>" class="btn btn-sm" target="_blank">Export Reports</a>
                </div>
                <div class="card recent-sales">

                    <div class="card-body">
                        <h5 class="card-title large-text"><?= ucfirst(esc($status)) ?> KPI Reports</h5>

                       <?php if (!empty($reports)) : ?>
    <div class="table-responsive">
        <table class="table table-hover datatable table-bordered">
            <thead>
                <tr>
                    <th scope="col" class="text-bg-secondary">KPI</th>
                    <th scope="col" class="text-bg-secondary">Submitted By/At</th>
                    <th scope="col" class="text-bg-secondary">Comment</th>
                    <th scope="col" class="text-bg-secondary">Percentage Completion</th>
                    <th scope="col" class="text-bg-secondary">Approved Percentage Completion</th>
                    <th scope="col" class="text-bg-secondary">Status</th>
                    <th scope="col" class="text-bg-secondary">Approved/Rejected By/At</th>
                    <th scope="col" class="text-bg-secondary">CSO Comment</th>
                    <th scope="col" class="text-bg-secondary">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reports as $report) : ?>
                    <tr>
                        <?php
                        $color = '';
                        if ($report['status'] === 'pending') {
                            $color = 'bg-warning';
                        } elseif ($report['status'] === 'rejected') {
                            $color = 'bg-danger';
                        } else {
                            $color = 'bg-success';
                        }
                        ?>
                        <td><?= esc($report['kpi']) ?></td>
                        <td><?= esc($report['project_lead']) ?><br>
                            <?= $report['created_at']
                                ? (new DateTime($report['created_at']))->format('h:i A d M Y')
                                : '-' ?>
                        </td>
                        <td><?= word_limiter(html_entity_decode($report['submitted_comment']), 10) ?></td>
                        <td><?= esc($report['percentage_of_completion']) ?? '-' ?> %</td>
                        <td><?= esc($report['approved_percentage_of_completion']) ?? '-' ?> %</td>
                        <td><span class="badge <?= $color ?>"><?= esc($report['status']) ?></span></td>
                        <td><?= esc($report['cso']) ?><br>
                            <?= $report['approved_at']
                                ? (new DateTime($report['approved_at']))->format('h:i A d M Y')
                                : '-' ?>
                        </td>
                        <td><?= esc($report['cso_comment']) ?></td>
                        <td>
                            <a class="btn btn-pink" href="<?= base_url('reports/' . $report['slug'] . '?type=kpi') ?>">More</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php else : ?>
    <div class="alert alert-info">No <?= esc($status) ?> KPI reports found</div>
<?php endif; ?>

                </div>
            </div><!-- end Goals -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>