
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>STracker</title>
  <meta content="" name="description">
  <meta content="Strategy, Performance, Management" name="keywords">

  <!-- Favicons -->
  <link rel="icon" href="<?= base_url('favicon.png') ?>" type="image/png">
  <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

  <meta property="og:url" content="<?= base_url('login') ?>">
  <meta property="og:type" content="Page" />
  <meta property="og:title" content="STracker | Learning Impact Model">
  <meta property="og:description" content="STracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
  <meta property="og:image" content="<?= base_url('assets/img/lim.jpg') ?>">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- apine js -->
  <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
  <!-- font-awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <!-- custom css -->
  <link rel="stylesheet" href="<?= base_url('assets/css/pre-loader.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>

<body>
  <!-- Preloader -->
  <div id="preloader"></div>

  <div class="row gy-4 my-4">
    <div class="d-none d-lg-block col-lg-5 order-lg-last">
      <img src="<?= base_url('assets/img/hero-img.png') ?>" class="img-fluid" alt="STracker">
    </div>
    <div class="col-lg-6 ms-5 d-flex flex-column justify-content-center">
      <!-- display logo if set -->
      <?php if (!empty($stracker)) : ?>
        <img src="<?= base_url($stracker['logo']) ?>" alt="Stracker | Learning Impact Model" style="max-width: 200px; height: auto;" class="mx-auto my-4">
      <?php endif; ?>
      <div class="bg-light w-100 mx-auto p-5">
        <h4 class="text-center medium-text ">Login</h4>

        <form action="<?= base_url('login') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
          <?= csrf_field() ?>

          <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="text" class="form-input" name="email" placeholder="Email">
            <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
          </div>

          <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" class="form-input" name="password" placeholder="Password">
            <p class="text-danger"><?= isset($validation) ? $validation->showError('password') : '' ?></p>
          </div>

          <?php if (isset($loginError)) : ?>

            <p class="text-danger mb-3 medium-text text-center"> <?= $loginError ?> </p>

          <?php endif; ?>

          <button class="btn btn-pink w-100" x-ref="btn">Login</button>

          <div class="my-3">
            Forgot password? <a href="<?= base_url('reset-password') ?>" class="text-decoration-none text-primary">Reset password here</a>
          </div>
          <div class="my-3">
            Read our <a href="<?= base_url('privacy-policy') ?>" class="text-decoration-none text-primary">privacy policy here</a>
          </div>

        </form>
      </div>
    </div>
  </div>
  <!-- bootstrap js -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/js/bootstrap.bundle.min.js"></script>

  <script src="<?= base_url('assets/js/pre-loader.js') ?>"></script>
  <script src="<?= base_url('assets/js/apine.js') ?>"></script>

</body>

</html>