<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>Organizations</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('dashboard') ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('organizations') ?>">Organizations</a></li>
                <li class="breadcrumb-item active">Create</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new organizations -->

            <div class="col-lg-9">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h6 class="my-4 text-center medium-text">Add new organization</h6>
                        <form method="POST" action="<?= base_url('organizations/create') ?>" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>

                            <div class="row mb-3">
                                <label for="name" class="col-sm-2 col-form-label">Name</label>
                                <div class="col-sm-10">
                                    <input type="name" class="form-input" id="name" name="name" value="<?= set_value('name') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="email" class="col-sm-2 col-form-label">Email</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-input" id="email" name="email" value="<?= set_value('email') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <label for="max_users" class="col-sm-2 col-form-label">Max. Users</label>
                                <div class="col-sm-10">
                                    <input type="number" class="form-input" id="max_users" name="max_users" value="<?= set_value('max_users') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('max_users') : '' ?></p>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-pink w-100" x-ref="btn">Save</button>
                        </form>
                    </div>
                    <!-- end add new organization form -->
                </div>
            </div>
        </div>
    </section>
</main>
<?= $this->endSection() ?>