<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>Organizations</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Home</a></li>
                <li class="breadcrumb-item active"><a href="<?= base_url('organizations') ?>">Organizations</a></li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <div class="container-fluid pt-4 px-4">
        <section class="section dashboard">
            <div class="row g-4">

                <!-- Organizations -->

                <div class="col-12">
                    <div class="card recent-sales overflow-auto">

                        <div class="filter">
                            <a class="icon" href="#" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                </li>

                                <li><a class="dropdown-item" href="#">Today</a></li>
                                <li><a class="dropdown-item" href="#">This Month</a></li>
                                <li><a class="dropdown-item" href="#">This Year</a></li>
                            </ul>
                        </div>

                        <div class="card-body">

                            <div class="filter text-end">
                                <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                    <li class="dropdown-header text-start">
                                        <h6>Filter</h6>
                                    </li>

                                    <li><a class="dropdown-item" href="<?= base_url('organizations?status=active') ?>">Active</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('organizations?status=inactive') ?>">Inactive</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('organizations') ?>" data-status="all">Show All</a></li>
                                </ul>
                            </div>

                            <h5 class="card-title large-text">
                                Organizations 
                                <span>| 
                                    <a href="<?= base_url('organizations/create') ?>" class="btn btn-sm text-primary">Add new</a>
                                </span>
                            </h5>

                            <?php if (!empty($organizations)) : ?>
                                <table class="table table-hover datatable">
                                    <thead>
                                        <tr>
                                            <th scope="col">Name</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Total Users</th>
                                            <th scope="col">Max. Users</th>
                                            <th scope="col">Subscription</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($organizations as $organization) : ?>
                                            <tr>
                                                <th scope="row"><?= esc($organization['name']) ?></th>
                                                <td><?= esc($organization['email']) ?></td>
                                                <td><?= esc($organization['total_users']) ?></td>
                                                <td><?= esc($organization['max_users']) ?></td>

                                                <!-- Subscription Info -->
                                                <td>
                                                    <?php if (!empty($organization['active_subscription'])) : ?>
                                                        <div>
                                                            <strong><?= ucfirst(esc($organization['active_subscription']['plan'])) ?></strong><br>
                                                            <small>
                                                                <?= date('M d, Y', strtotime($organization['active_subscription']['start_date'])) ?> 
                                                                – 
                                                                <?= date('M d, Y', strtotime($organization['active_subscription']['end_date'])) ?>
                                                            </small>
                                                        </div>
                                                    <?php else : ?>
                                                        <span class="text-muted small">No active subscription</span>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <span class="badge <?= esc($organization['status']) === 'active' ? 'bg-success' : 'bg-danger' ?>">
                                                        <?= esc($organization['status']) ?>
                                                    </span>
                                                </td>

                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">
                                                            <a href="<?= base_url('organizations/update/' . $organization['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                            </a>

                                                            <?php if ($organization['status'] === 'active') : ?>
                                                                <form action="<?= base_url('organizations/disable/' . esc($organization['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>
                                                                    <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                        <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>
                                                            <?php else : ?>
                                                                <form action="<?= base_url('organizations/enable/' . esc($organization['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>
                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>

                                                            <a href="<?= base_url('organization/' . $organization['slug']) ?>" class="action-btn text-bg-light" title="Organization Settings">
                                                                <i class="fa fa-gear ms-1" style="font-size:15px"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            <?php else : ?>
                                <p class="text-center my-4 text-muted">No organizations found.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div><!-- end Organizations -->

            </div>
        </section>
    </div>
</main>

<?= $this->endSection() ?>
