<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('structures') ?>">Structures</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-lg-8">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h1 class="my-4 medium-text">Create Organization Structure Item</h1>

                        <form action="<?= base_url('create/structures') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>

                            <div class="mb-3">
                                <fieldset class="row mb-3">
                                    <legend class="col-form-label col-sm-2 pt-0">Type</legend>
                                    <div class="col-sm-10">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="type" id="sbu" value="SBU">
                                            <label class="form-check-label" for="sbu">
                                                SBU
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="type" id="division" value="Division">
                                            <label class="form-check-label" for="division">
                                                Division
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="type" id="department" value="Department">
                                            <label class="form-check-label" for="department">
                                                Department
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="type" id="unit" value="Unit">
                                            <label class="form-check-label" for="unit">
                                                Unit
                                            </label>
                                        </div>
                                    </div>
                                </fieldset>
                                <p class="text-danger"><?= isset($validation) ? $validation->showError('type') : '' ?></p>
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-input" name="name">
                                <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                            </div>

                            <button class="btn btn-pink w-100" x-ref="btn">Save</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>