<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('structures') ?>">Structures</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <?php if (!empty($organization)) : ?>
                            <h5 class="card-title large-text">Structures <span>| <a href="<?= base_url('create/structures') ?>" class="btn btn-sm text-primary">Add new</a></span></h5>
                        <?php endif; ?>
                        <?php if (!empty($structures)) : ?>
                            <table class="table table-hover table-bordered datatable">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Type</th>
                                        <th scope="col" class="text-bg-secondary">Name</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($structures as $structure) : ?>
                                        <tr>
                                            <th><?= esc($structure['type']) ?></th>
                                            <td><?= esc($structure['name']) ?></td>
                                            <td><span class="badge <?= esc($structure['status']) === 'active' ? 'bg-success' : 'bg-danger' ?>"><?= esc($structure['status']) ?></span></td>
                                            <td>
                                                <div class="status-actions">
                                                    <div class="actions">

                                                        <a href="<?= base_url('update/structure/' . $structure['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                            <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                        </a>

                                                        <?php if ($structure['status'] === 'active') : ?>

                                                            <form action="<?= base_url('structure/disable/' . esc($structure['id'])) ?>" method="post" style="display:inline;">
                                                                <?= csrf_field() ?>

                                                                <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                    <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                </button>
                                                            </form>

                                                        <?php else: ?>
                                                            <form action="<?= base_url('structure/enable/' . esc($structure['id'])) ?>" method="post" style="display:inline;">
                                                                <?= csrf_field() ?>

                                                                <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                    <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                </button>
                                                            </form>

                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>

                    </div>

                </div>
            </div><!-- end Organizations -->
            <?php else : ?>
                <div class="alert alert-info">No organization structures found</div>
        <?php endif; ?>
        </div>
    </section>
</main>
<?= $this->endSection() ?>