<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>S-Tracker</title>
    <meta name="description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta content="Strategy, Performance, Management, Learning, Impact, Model" name="keywords">

    <!-- Favicons -->
    <link rel="shortcut icon" href="<?= base_url('favicon.png') ?>" type="image/png">
    <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

    <meta property="og:url" content="<?= base_url('login') ?>">
    <meta property="og:type" content="Page" />
    <meta property="og:title" content="S-Tracker | Learning Impact Model">
    <meta property="og:description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta property="og:image" content="<?= base_url('assets/img/lim.jpg') ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?= base_url('assets2/vendor/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/bootstrap-icons/bootstrap-icons.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/aos/aos.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/glightbox/css/glightbox.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.css') ?>" rel="stylesheet">

    <!-- Main CSS File -->
    <link href="<?= base_url('assets2/css/main.css') ?>" rel="stylesheet">
</head>

<body class="index-page">

    <header id="header" class="header d-flex align-items-center fixed-top">
        <div class="container position-relative d-flex align-items-center justify-content-between">

            <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center me-auto me-xl-0">
                <!-- Uncomment the line below if you also wish to use an image logo -->
                <img src="<?= session()->has('logo') ? base_url(session()->get('logo')) : '' ?>" alt="S-Tracker">
                <!-- <h1 class="sitename">S-Tracker</h1> -->
            </a>

            <nav id="navmenu" class="navmenu">
                <ul>
                    <li><a href="<?= base_url('/') ?>">Home</a></li>
                    <li><a href="<?= base_url('privacy-policy') ?>" class="active">Privacy Policy</a></li>

                    <!-- <li><a href="#contact">Contact</a></li> -->
                </ul>
                <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
            </nav>

            <a class="btn-getstarted" href="<?= base_url('login') ?>">Login</a>

        </div>
    </header>

    <main class="main mt-5">

        <section class="pricing-area style_two inner_page m-0 py-5 mt-5">
            <div class="container">
                <div class="row mb-4">
                    <div class="col-lg-12">
                        <div class="section_title text-center">
                            <h2 class="fw-bold text-primary mt-5">S-Tracker Privacy Policy</h2>
                            <p class="text-muted">Effective Date: 31 December 2024</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-10 mx-auto">

                        <p class="lead">
                            S-Tracker ("we", "us", or "our") is committed to safeguarding the privacy of organizations, strategy officers, and individual users of our platform.
                            This Privacy Policy outlines how we collect, use, disclose, and protect information in compliance with the Nigeria Data Protection Act (NDPA), GDPR (where applicable), and other relevant regulations.
                        </p>

                        <hr>

                        <h4 class="fw-bold text-dark mt-4">Our Operations</h4>
                        <p>
                            S-Tracker is a strategy management platform that enables companies to define, monitor, and track their corporate strategy.
                            We provide tools for capturing strategic themes, goals, and initiatives, as well as assigning owners and tracking progress through evidence submissions.
                            S-Tracker operates under <a href="https://learningimpactmodel.com" target="_blank">Learning Impact Model</a> and related platforms.
                        </p>

                        <h4 class="fw-bold text-dark mt-4">What Data We Collect</h4>
                        <ul class="list-group mb-3">
                            <li class="list-group-item"><strong>Account Information:</strong> Name, email address, organization, department, role, and login credentials.</li>
                            <li class="list-group-item"><strong>Strategy Data:</strong> Company strategic goals, initiatives, assigned owners, progress updates, and evidence submissions.</li>
                            <li class="list-group-item"><strong>Usage Data:</strong> Activity logs, task completion history, and interactions within the platform.</li>
                            <li class="list-group-item"><strong>Technical Information:</strong> IP address, browser type, device details, and system usage data.</li>
                        </ul>

                        <h4 class="fw-bold text-dark mt-4">How We Use Your Data</h4>
                        <p>We process collected data for the following purposes:</p>
                        <ul class="list-unstyled ps-3">
                            <li>To provide access to S-Tracker features and functionalities.</li>
                            <li>To track initiatives, monitor progress, and generate performance reports.</li>
                            <li>To facilitate collaboration between users, departments, and leadership teams.</li>
                            <li>To improve the platform’s usability, security, and overall experience.</li>
                            <li>To comply with legal and regulatory obligations.</li>
                        </ul>

                        <h4 class="fw-bold text-dark mt-4">Data Sharing and Disclosure</h4>
                        <p>We do not sell or rent personal data. Data may be shared with:</p>
                        <ul class="list-unstyled ps-3">
                            <li>Other authorized users within your organization for collaboration and reporting.</li>
                            <li>Service providers and trusted vendors who support our platform under confidentiality agreements.</li>
                            <li>Regulatory or legal authorities where disclosure is required by law.</li>
                        </ul>

                        <h4 class="fw-bold text-dark mt-4">Your Rights</h4>
                        <p>Depending on your jurisdiction, you may have the right to:</p>
                        <ul class="list-unstyled ps-3">
                            <li>Access, correct, or delete your personal data.</li>
                            <li>Object to or restrict processing of your data.</li>
                            <li>Withdraw your consent at any time.</li>
                            <li>Lodge a complaint with a data protection authority.</li>
                        </ul>
                        <p>
                            To exercise these rights, contact us at:
                            <a href="mailto:info@learningimpactmodel.com">info@learningimpactmodel.com</a>
                        </p>

                        <h4 class="fw-bold text-dark mt-4">Security of Your Data</h4>
                        <p>
                            We implement technical, administrative, and organizational measures to protect information against unauthorized access, loss, alteration, or disclosure.
                        </p>

                        <h4 class="fw-bold text-dark mt-4">Cookies and Tracking Technologies</h4>
                        <p>
                            S-Tracker uses cookies and similar technologies to enhance user experience and monitor system performance.
                            You may manage cookie preferences through your browser settings.
                        </p>

                        <h4 class="fw-bold text-dark mt-4">Changes to This Policy</h4>
                        <p>
                            We may update this policy periodically. Updated versions will be posted on our platform with a revised effective date.
                        </p>

                        <h4 class="fw-bold text-dark mt-4">Contact Us</h4>
                        <p>If you have questions about this Privacy Policy or our data practices, please contact us at:</p>
                        <div class="alert alert-secondary">
                            <strong>Email:</strong> <a href="mailto:info@learningimpactmodel.com">info@learningimpactmodel.com</a><br>
                            <strong>Address:</strong> Suite 3F4, Katu Koma Plaza, 52 Off Oladipo Diya Way, Sector Centre C, Abuja, FCT, Nigeria.
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer id="footer" class="footer position-relative dark-background">

        <div class="container footer-top">
            <div class="row gy-4">
                
                <div class="col-lg-5 col-md-12 footer-about">
                    <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center">
                        <span class="sitename">S-Tracker</span>
                    </a>
                    <p>
                        S-Tracker helps organizations design, track, and achieve their strategic goals.
                        Built on the Balanced Scorecard framework, it empowers leaders to align initiatives,
                        assign ownership, and monitor execution with clarity and accountability.
                    </p>
                    <div class="social-links d-flex mt-4">
                        <!-- <a href=""><i class="bi bi-twitter-x"></i></a> -->
                        <a href="https://www.facebook.com/profile.php?id=100093117607351" target="_blank"><i class="bi bi-facebook"></i></a>
                        <a href="https://www.instagram.com/learningimpactmodel/?hl=en" target="_blank"><i class="bi bi-instagram"></i></a>
                        <a href="https://www.linkedin.com/company/bebetterlearningimpactng/" target="_blank"><i class="bi bi-linkedin"></i></a>
                    </div>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Useful Links</h4>
                    <ul>
                        <li><a href="<?= base_url('/') ?>">Home</a></li>
                        
                        <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Other Products</h4>
                    <ul>
                        <li><a href="https://onlineefiko.com" target="_blank">Online Efiko</a></li>
                        <li><a href="https://lifeskillsafrica.com" target="_blank">Life Skills Africa</a></li>
                        <li><a href="https://360feedback.com.ng" target="_blank">360 Feedback Solutions</a></li>
                        <li><a href="https://epapervendor.com" target="_blank">Epaper Vendor</a></li>
                    </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                    <h4>Contact Us</h4>
                    <p>Suite 3F4, Katu Koma Plaza,  </p>
                    <p>52 Off Oladipo Diya Way,</p>
                    <p>Sector Centre C, Abuja, FCT, Nigeria.</p>
                    <p class="mt-4"><strong>Phone:</strong> <span> +234 8051953276</span></p>
                    <p><strong>Email:</strong> <span>info@learninigimpactmodel.com</span></p>
                </div>

            </div>
        </div>
        <div class="container copyright text-center mt-4">
            <p>
                © <span id="year"></span> <span>Copyright</span>
                <strong class="px-1 sitename">S-Tracker</strong>
                <span>All Rights Reserved</span>
            </p>

        <script>
            document.getElementById("year").textContent = new Date().getFullYear();
        </script>
            <div class="credits">
                Designed by <a href="https://learningimpactmodel.com/" target="_blank">Learning Impact Model</a>
            </div>
        </div>

    </footer>

    <!-- Scroll Top -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="<?= base_url('assets2/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/php-email-form/validate.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/aos/aos.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/glightbox/js/glightbox.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/purecounter/purecounter_vanilla.js') ?>"></script>

    <!-- Main JS File -->
    <script src="<?= base_url('assets2/js/main.js') ?>"></script>

</body>

</html>