<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Reset Password - STracker</title>
  <meta content="" name="description">
  <meta content="Strategy, Performance, Management" name="keywords">

  <!-- Favicons -->
  <link rel="icon" href="<?= base_url('favicon.png') ?>" type="image/png">
  <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet">
 <!-- apine js -->
 <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
  <!-- font-awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  
  <!-- custom css -->
  <link rel="stylesheet" href="<?= base_url('assets/css/pre-loader.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>

<body>
  <!-- Preloader -->
  <div id="preloader"></div>

  <div class="row gy-4 my-4">
    <div class="d-none d-lg-block col-lg-5 order-lg-last">
      <img src="<?= base_url('assets/img/hero-img.png') ?>" class="img-fluid" alt="STracker">
    </div>
    <div class="col-lg-6 ms-5 d-flex flex-column justify-content-center">
      <h2 class="text-center">logo</h2>
      <h4 class="text-center large-text">Set up new password</h4>

      <form action="<?= base_url('reset-password/confirm/'. $user['reset_token']) ?>" method="post" class="p-4 bg-light" style="min-height: 50%;" x-data="formSubmit" @submit.prevent="submit">
        <?= csrf_field() ?>

        <div class="mb-3">
          <label for="password" class="form-label">New Passowrd</label>
          <input type="password" class="form-input" name="password" placeholder="Passowrd">
          <p class="text-danger"><?= isset($validation) ? $validation->showError('password') : '' ?></p>
        </div>

        <div class="mb-3">
          <label for="confirm_password" class="form-label">Confirm New Password</label>
          <input type="password" class="form-input" name="confirm_password" placeholder="Confirm Password">
          <p class="text-danger"><?= isset($validation) ? $validation->showError('confirm_password') : '' ?></p>
        </div>

        <?php if (isset($invalidUser)) : ?>

          <p class="text-danger mb-3 large-text text-center"> <?= $invalidUser ?> </p>

        <?php endif; ?>

        <button class="btn btn-pink w-100" x-ref="btn">Update</button>

        <div class="my-3">
          Remember your password?<a href="<?= base_url('login') ?>" class="text-decoration-none text-primary"> Sign in</a>
        </div>
      </form>
    </div>
  </div>

  <!-- bootstrap js -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/js/bootstrap.bundle.min.js"></script>

  <script src="<?= base_url('assets/js/pre-loader.js') ?>"></script>
  <script src="<?= base_url('assets/js/apine.js') ?>"></script>

</body>

</html>