<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>
<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <li class="breadcrumb-item"><a href="#">Submissions</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- KPIs from an initiative -->

            <div class="col-lg-9">
                <div class="card recent-sales">

                    <div class="card-body">
                        <?php if (!in_array(session()->get('role'), ['admin', 'chief_startegy_officer', 'superadmin'])): ?>
                            <h4 class="text-center medium-text card-title">Make Submission</h4>
                            <form action="<?= base_url('my-initiatives/' . esc($initiative['slug']) . '/submissions/create') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                <?= csrf_field() ?>
                                <input type="hidden" value="<?= $initiative['id'] ?>" name="id">
                                <div class="row">

                                    <div class="mb-1 col-12">
                                        <label for="comment" class="form-label">Comment</label>
                                        <textarea name="comment" class="form-input" rows="5" id="editor"><?= set_value('comment') ?></textarea>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('comment') : '' ?></p>
                                    </div>

                                    <div class="mb-1 col-12">
                                        <label for="percentage_of_completion" class="form-label">Percentage Completion</label>
                                        <input
                                            class="form-range"
                                            type="range"
                                            name="percentage_of_completion"
                                            id="percentage_of_completion"
                                            min="0"
                                            max="100"
                                            step="5"
                                            value="<?= set_value('percentage_of_completion') ?? 0 ?>"
                                            oninput="document.getElementById('percentValue').innerText = this.value + '%';">
                                        <span id="percentValue">0%</span>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('percentage_of_completion') : '' ?></p>
                                    </div>


                                    <div class="mb-1 col-12">
                                        <label for="file" class="form-label">Supporting files</label>
                                        <input type="file" name="file" id="file" class="form-input" accept=".pdf,image/*">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('file') : '' ?></p>
                                    </div>

                                </div>

                                <button class="btn btn-pink w-100" x-ref="btn">Save</button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>