<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">KPIs</a></li>
                    <li class="breadcrumb-item active"><a href="#">Reports</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <?php if (!empty($kpi)) : ?>
                            <h5 class="card-title large-text">Reports
                                <?php if (in_array(session()->get('role'), ['project_lead', 'department_head', 'superadmin'])): ?>
                                    <?php if ($kpi['status'] === 'active') : ?>
                                        <span>| <a href="<?= base_url('my-kpis/' . $kpi['slug'] . '/submissions/create') ?>" class="btn btn-sm text-primary">Add new</a></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </h5>
                        <?php endif; ?>
                        <?php if (!empty($submissions)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">KPI</th>
                                        <th scope="col" class="text-bg-secondary">Comment</th>
                                        <th scope="col" class="text-bg-secondary">Percentage Completion</th>
                                                                                <th scope="col" class="text-bg-secondary">Approved Percentage Completion</th>
                                        <th scope="col" class="text-bg-secondary">Submitted By/At</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary">Approved/Rejected By/At</th>
                                        <th scope="col" class="text-bg-secondary">CSO Comment</th>
                                        <th scope="col" class="text-bg-secondary">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($submissions as $submission) : ?>
                                                                                    <?php
                                            $color = '';
                                            if ($submission['status'] === 'pending') {
                                                $color = 'bg-warning';
                                            } elseif ($submission['status'] === 'rejected') {
                                                $color = 'bg-danger';
                                            } else {
                                                $color = 'bg-success';
                                            }
                                            ?>

                                        <tr>
                                            <td><?= esc($kpi['name']) ?></td>
                                            <td><?= word_limiter(html_entity_decode($submission['submitted_comment']), 10) ?></td>
                                            <td><?= esc($submission['percentage_of_completion']) ?? '-' ?> %</td>
<td><?= esc($submission['approved_percentage_of_completion']) ?? '-' ?> %</td>
<td>
    <?= esc($submission['submitted_by']) ?>
    <br>
    <?= (new DateTime($submission['created_at']))->format('h:i A d M Y') ?>
</td>

                                            <td><span class="badge <?= $color ?>"><?= esc($submission['status']) ?></span></td>
                                            <td><?= esc($submission['cso_name']) ?>
                                                <br>
                                                <?= $submission['approved_at']
                                                    ? (new DateTime($submission['approved_at']))->format('h:i A d M Y')
                                                    : '-' ?>
                                            </td>
                                            <td><?= esc($submission['cso_comment']) ?></td>
                                            <td>
                                                <!-- full submission Modal -->
                                                <button type="button" class="btn btn-pink btn-sm" data-bs-toggle="modal" data-bs-target="#<?= $submission['slug'] ?>">
                                                    More
                                                </button>

                                                <div class="modal fade" id="<?= $submission['slug'] ?>" tabindex="-1">
                                                    <div class="modal-dialog modal-xl modal-dialog-scrollable">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title large-text">Comment</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <p>
                                                                    <?= html_entity_decode($submission['submitted_comment']) ?>
                                                                </p>

                                                                <?php if ($submission['document_link'] !== null): ?>
                                                                    <h2 class="medium-text">Document</h2>

                                                                    <?php
                                                                    $fileLink = base_url($submission['document_link']);
                                                                    $extension = strtolower(pathinfo($fileLink, PATHINFO_EXTENSION));
                                                                    ?>

                                                                    <?php if (in_array($extension, ['jpg', 'jpeg', 'png'])): ?>
                                                                        <img src="<?= esc($fileLink) ?>" alt="Uploaded Image" style="max-width: 100%; height: auto; border: 1px solid #ccc; margin-top: 10px;">
                                                                    <?php elseif ($extension === 'pdf'): ?>
                                                                        <iframe src="<?= esc($fileLink) ?>" width="100%" height="600px" style="border: 1px solid #ccc; margin-top: 10px;"></iframe>
                                                                        <!-- Or alternatively: <a href="fileLink" target="_blank">Open PDF</a> -->
                                                                    <?php else: ?>
                                                                        <p>Unsupported file type.</p>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>

                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div><!-- End full submission Modal-->
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                        <?php else: ?>
                            <div class="alert alert-info">No submissions found</div>
                        <?php endif; ?>
                    </div>

                </div>
            </div><!-- end Organizations -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>