<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>Subscriptions</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('dashboard') ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('subscriptions') ?>">Subscriptions</a></li>
                <li class="breadcrumb-item active">Edit</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
        <div class="row g-4">

            <div class="col-lg-9">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h6 class="my-4 text-center medium-text">Edit Subscription</h6>
                        <form method="POST" action="<?= base_url('subscriptions/update/' . $subscription['slug']) ?>" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>
                            <input type="hidden" name="_method" value="PUT" >

                            <div class="row mb-3">
                                <label for="organization_id" class="col-sm-3 col-form-label">Organization</label>
                                <div class="col-sm-9">
                                    <select name="organization_id" id="organization_id" class="form-input">
                                        <option value="">Select</option>
                                        <?php if(!empty($organizations)) : ?>
                                            <?php foreach($organizations as $organization) : ?>
                                                <option 
                                                    value="<?= $organization['id'] ?>" 
                                                    <?= ($subscription['organization_id'] == $organization['id']) ? 'selected' : '' ?>>
                                                    <?= $organization['name'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('organization_id') : '' ?></p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="plan" class="col-sm-3 col-form-label">Plan</label>
                                <div class="col-sm-9">
                                    <select name="plan" id="plan" class="form-input">
                                        <option value="">Select</option>
                                        <option value="starter" <?= ($subscription['plan'] === 'starter') ? 'selected' : '' ?>>Starter</option>
                                        <option value="growth" <?= ($subscription['plan'] === 'growth') ? 'selected' : '' ?>>Growth</option>
                                        <option value="enterprise" <?= ($subscription['plan'] === 'enterprise') ? 'selected' : '' ?>>Enterprise</option>
                                        <option value="corporate" <?= ($subscription['plan'] === 'corporate') ? 'selected' : '' ?>>Corporate</option>
                                    </select>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('plan') : '' ?></p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="start_date" class="col-sm-3 col-form-label">Start Date</label>
                                <div class="col-sm-9">
                                    <input 
                                        type="date" 
                                        class="form-input" 
                                        id="start_date" 
                                        name="start_date" 
                                        value="<?= date('Y-m-d', strtotime($subscription['start_date'])) ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('start_date') : '' ?></p>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="end_date" class="col-sm-3 col-form-label">End Date</label>
                                <div class="col-sm-9">
                                    <input 
                                        type="date" 
                                        class="form-input" 
                                        id="end_date" 
                                        name="end_date" 
                                        value="<?= date('Y-m-d', strtotime($subscription['end_date'])) ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('end_date') : '' ?></p>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-pink w-100" x-ref="btn">Update Subscription</button>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </section>
</main>

<?= $this->endSection() ?>
