<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>subscriptions</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Home</a></li>
                <li class="breadcrumb-item active"><a href="<?= base_url('subscriptions') ?>">Subscriptions</a></li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <div class="container-fluid pt-4 px-4">
        <section class="section dashboard">
            <div class="row g-4">

                <!-- subscriptions -->

                <div class="col-12">
                    <div class="card recent-sales overflow-auto">

                        <div class="filter">
                            <a class="icon" href="#" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                </li>

                                <li><a class="dropdown-item" href="#">Today</a></li>
                                <li><a class="dropdown-item" href="#">This Month</a></li>
                                <li><a class="dropdown-item" href="#">This Year</a></li>
                            </ul>
                        </div>

                        <div class="card-body">

                            <div class="filter text-end">
                                <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                    <li class="dropdown-header text-start">
                                        <h6>Filter</h6>
                                    </li>

                                    <li><a class="dropdown-item" href="<?= base_url('subscriptions?status=active') ?>">Active</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('subscriptions?status=expired') ?>">Expired</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('subscriptions') ?>" data-status="all">Show All</a></li>

                                </ul>
                            </div>

                            <h5 class="card-title large-text">Subscriptions <span>| <a href="<?= base_url('subscriptions/create') ?>" class="btn btn-sm text-primary">Add new</a></span></h5>
                            <?php if (!empty($subscriptions)) : ?>
                                <table class="table table-hover datatable">
                                    <thead>
                                        <tr>
                                            <th scope="col">Organization</th>
                                            <th scope="col">Plan</th>
                                            <th scope="col">Start Date</th>
                                            <th scope="col">Date of Expiry</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($subscriptions as $subscription) : ?>
                                            <tr>
                                                <th scope="row"><?= esc($subscription['organization_name']) ?></th>
                                                <th scope="row"><?= ucfirst(esc($subscription['plan'])) ?></th>
                                            <td><?= (new DateTime($subscription['start_date']))->format('d F, Y') ?></td>
                                            <td><?= (new DateTime($subscription['end_date']))->format('d F, Y') ?></td>
                                                <td><span class="badge <?= esc($subscription['status']) === 'active' ? 'bg-success' : 'bg-danger' ?>"><?= esc($subscription['status']) ?></span></td>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">

                                                            <a href="<?= base_url('subscriptions/update/' . $subscription['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                            </a>

                                                            <?php if ($subscription['status'] === 'active') : ?>

                                                                <form action="<?= base_url('subscriptions/disable/' . esc($subscription['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-danger" title="Mark Expired" type="submit">
                                                                        <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php else: ?>
                                                                <form action="<?= base_url('subscriptions/enable/' . esc($subscription['id'])) ?>" method="post" style="display:inline;">
                                                                    <?= csrf_field() ?>

                                                                    <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                        <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                    </button>
                                                                </form>

                                                            <?php endif; ?>
                                                        </div>
                                                    </div>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>

                                    </tbody>
                                </table>

                        </div>

                    </div>
                </div><!-- end subscriptions -->
            <?php endif; ?>
            </div>
        </section>
    </div>
</main>

<?= $this->endSection() ?>