<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('themes') ?>">Themes</a></li>
                    <li class="breadcrumb-item active"><a href="#">Update</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <?php if(!empty($theme)) : ?>
    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-lg-9">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h1 class="my-4 medium-text">Update Theme</h1>

                        <form action="<?= base_url('update/themes/' . $theme['slug']) ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>
                            <input type="hidden" name="_method" value="PUT">
                            <input type="hidden" name="id" value="<?= $theme['id'] ?>">

                            <div class="row">
                                <div class="mb-3 col-12">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" class="form-input" name="title" value="<?= esc($theme['title']) ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('title') : '' ?></p>
                                </div>

                                <div class="mb-3 col-12">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" rows="4" class="form-input"><?= esc($theme['description']) ?></textarea>
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('description') : '' ?></p>
                                </div>

                                <div class="mb-3 col-12">
                                    <label for="timeline" class="form-label">Timeline</label>
                                    <input type="date" class="form-input" name="timeline" value="<?= esc($theme['timeline']) ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('timeline') : '' ?></p>
                                </div>
                            </div>
                            <button class="btn btn-pink w-100" x-ref="btn">Update Theme</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
</main>
<?= $this->endSection() ?>