<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('themes') ?>">Themes</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('themes?action=download') ?>" class="btn btn-sm" target="_blank">Export Themes</a>
                </div>
                <div class="card recent-sales overflow-auto">

                    <div class="filter text-end">
                        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                            <li class="dropdown-header text-start">
                                <h6>Filter</h6>
                            </li>

                            <li><a class="dropdown-item" href="<?= base_url('themes?status=completed') ?>">Completed</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('themes?status=active') ?>">Active</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('themes?status=inactive') ?>">Inactive</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('themes?status=due') ?>">Behind Schedule</a></li>
                            <li><a class="dropdown-item" href="<?= base_url('themes') ?>">Show All</a></li>

                        </ul>
                    </div>

                    <div class="card-body">
                        <?php if (!empty($organization)) : ?>
                            <h5 class="card-title large-text">Strategic Themes
                                <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                    <span>| <a href="<?= base_url('themes/create') ?>" class="btn btn-sm text-primary">Add new</a></span>
                                <?php endif; ?>
                            </h5>
                        <?php endif; ?>

                        <?php if (!empty($themes)) : ?>
                            <table class="table table-bordered datatable table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">Title</th>
                                        <th scope="col" class="text-bg-secondary">Description</th>
                                        <th scope="col" class="text-bg-secondary">Timeline</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'chief_strategy_officer'])): ?>
                                            <th scope="col" class="text-bg-secondary">Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($themes as $theme) : ?>
                                        <?php
                                        /*
                                        $statusColor = '';
                                        if ($theme['status'] === 'active') {
                                            $statusColor = 'text-bg-primary';
                                        }

                                        if ($theme['status'] === 'completed') {
                                            $statusColor = 'text-bg-secondary';
                                        }

                                        if ($theme['status'] === 'inactive') {
                                            $statusColor = 'text-bg-dark';
                                        } */
                                        ?>
                                        <tr>
                                            <td><?= esc(ucfirst($theme['title'])) ?></td>
                                            <td><?= esc($theme['description']) ?></td>
                                            <td><?= (new DateTime($theme['timeline']))->format('d F, Y') ?></td>
                                            <td><span class="badge text-bg-dark"><?= esc($theme['status']) ?></span></td>
                                            <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'chief_strategy_officer'])): ?>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">

                                                            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>

                                                                <a href="<?= base_url('update/themes/' . $theme['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                    <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                                </a>

                                                                <?php if ($theme['status'] === 'active') : ?>

                                                                    <form action="<?= base_url('themes/disable/' . esc($theme['id'])) ?>" method="post" style="display:inline;">
                                                                        <?= csrf_field() ?>

                                                                        <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                            <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                        </button>
                                                                    </form>

                                                                <?php else: ?>
                                                                    <form action="<?= base_url('themes/enable/' . esc($theme['id'])) ?>" method="post" style="display:inline;">
                                                                        <?= csrf_field() ?>

                                                                        <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                            <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                        </button>
                                                                    </form>

                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                            <div class="dropdown">
                                                                <button class="badge text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                    more
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                                                                        <?php if ($theme['status'] !== 'completed') : ?>
                                                                            <form action="<?= base_url('themes/' . esc($theme['id']) . '/complete') ?>" method="post" style="display:inline;">
                                                                                <?= csrf_field() ?>

                                                                                <button class="dropdown-item text-success" title="Mark Complete" type="submit">
                                                                                    <i class='fa fa-check-circle'></i> Mark Complete
                                                                                </button>
                                                                            </form>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>

                                                                    <li>
                                                                        <a href="<?= base_url('themes/view/' . $theme['slug']) ?>" class="btn btn-sm dropdown-item" title="view">
                                                                            <i class="fa fa-eye"></i> View
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>

                                </tbody>
                            </table>

                    </div>

                </div>
            </div><!-- end Organizations -->
        <?php else : ?>
            <div class="alert alert-info">No themes found</div>
        <?php endif; ?>
        </div>
    </section>
</main>

<?= $this->endSection() ?>