<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('themes') ?>">Themes</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="text-end">
                    <a href="<?= base_url('themes/view/' . $theme['slug'] . '?action=download') ?>" class="btn btn-sm" target="_blank">Export Theme</a>
                </div>
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">

                        <h2 class="large-text text-center card-title">Theme: <?= esc($theme['title']) ?></h2>

                        <!-- loop out theme details from theme controller -->
                        <?php if (!empty($groupedData)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th class="text-bg-secondary">Strategy Framework Perspective</th>
                                        <th class="text-bg-secondary">High Level Goals</th>
                                        <th class="text-bg-secondary">Initiatives</th>
                                        <th class="text-bg-secondary">Timeline</th>
                                        <th class="text-bg-secondary">Responsibility</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($groupedData as $perspectiveName => $goals): ?>
                                        <?php foreach ($goals as $goalData): ?>
                                            <tr>
                                                <td><?= esc($perspectiveName) ?></td>
                                                <td><?= html_entity_decode(esc($goalData['goal']['description'])) ?></td>

                                                <!-- Initiatives (unordered list) -->
                                                <td>
                                                    <ul>
                                                        <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                                            <li class="mb-3"><?= esc($initiative['name']) ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </td>
                                                <td>
                                                    <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                                        <p>
                                                            <?= !empty($initiative['end_date'])
                                                                ? (new DateTime($initiative['end_date']))->format('d M, Y')
                                                                : '-' ?>
                                                        </p>
                                                    <?php endforeach; ?>
                                                </td>

                                                <!-- Owners (unordered list) -->
                                                <td>
                                                    <?php foreach ($goalData['initiatives'] as $initiative): ?>
                                                        <p>
                                                            <?= !empty($initiative['owners'])
                                                                ? esc(implode(' / ', $initiative['owners']))
                                                                : '-' ?>
                                                        </p>
                                                    <?php endforeach; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <div class="alert alert-info">No goals found for this theme.</div>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
<?= $this->endSection() ?>