<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-lg-9">
                <!-- loop out the initiatives if available -->
                <div class="card">
                    <div class="card-body">
                        <h4 class="text-center card-title medium-text">Change Password</h4>
                        <form action="<?= base_url('user/change-password') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>
                            <input type="hidden" name="_method" value="PUT">

                            <div class="row">

                                <div class="mb-1 col-12">
                                    <label for="old_password" class="form-label">Old Password</label>
                                    <input type="password" class="form-input" name="old_password">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('old_password') : '' ?></p>
                                </div>

                                <div class="mb-1 col-12">
                                    <label for="new_password" class="form-label">New Password</label>
                                    <input type="password" class="form-input" name="new_password">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('new_password') : '' ?></p>
                                </div>

                                <div class="mb-1 col-12">
                                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                                    <input type="password" class="form-input" name="password_confirmation">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('password_confirmation') : '' ?></p>
                                </div>

                                <?php if (isset($passwordError)) : ?>

                                    <p class="text-danger mb-3 medium-text text-center"> <?= $passwordError ?> </p>

                                <?php endif; ?>

                            </div>

                            <button class="btn btn-pink w-100" x-ref="btn">Update Password</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>