<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row">

            <!-- Left side columns -->
            <div class="col-lg-12">
                <div class="row">
                    <?php if (in_array(session()->get('role'), ['project_lead', 'department_head'])): ?>
                        <!-- my initiatives Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">My Initiatives</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-initiatives?status=completed') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Completed</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $completedInitiatives ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-initiatives?status=active') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Pending</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $activeInitiatives ?></span>
                                                    </li>
                                                </a>


                                                <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-initiatives?status=due') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Behind Schedule</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $dueInitiatives ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-initiatives') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Total</div>
                                                        </div>
                                                        <span class="badge bg-primary rounded-pill"><?= $totalInitiatives ?></span>
                                                    </li>
                                                </a>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="initiativesCont" width="400" height="130"></canvas>
                                        </div>

                                        <script>
                                            const initiativesCont = document.getElementById('initiativesCont').getContext('2d');
                                            const initiativesChart = new Chart(initiativesCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Completed', 'Pending', 'Behind Schedule'],
                                                    datasets: [{
                                                        data: [<?= $completedInitiatives ?>, <?= $activeInitiatives ?>, <?= $dueInitiatives ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End my initiatives Card -->

                        <!-- my kpis Card -->
                        <div class="col-lg-6">

                            <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis') ?>">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title large-text">My KPIs</h5>

                                        <div class="row">
                                            <div class="col-12">
                                                <!-- List group with custom content -->
                                                <ol class="list-group">
                                                    <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=completed') ?>">
                                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                                            <div class="ms-2 me-auto">
                                                                <div class="fw-bold">Completed</div>
                                                            </div>
                                                            <span class="badge bg-success rounded-pill"><?= $completedKPIs ?></span>
                                                        </li>
                                                    </a>

                                                    <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=active') ?>">
                                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                                            <div class="ms-2 me-auto">
                                                                <div class="fw-bold">Pending</div>
                                                            </div>
                                                            <span class="badge bg-warning rounded-pill"><?= $activeKPIs ?></span>
                                                        </li>
                                                    </a>

                                                    <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=due') ?>">
                                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                                            <div class="ms-2 me-auto">
                                                                <div class="fw-bold">Behind Schedule</div>
                                                            </div>
                                                            <span class="badge bg-danger rounded-pill"><?= $dueKPIs ?></span>
                                                        </li>
                                                    </a>

                                                    <a href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis') ?>">
                                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                                            <div class="ms-2 me-auto">
                                                                <div class="fw-bold">Total</div>
                                                            </div>
                                                            <span class="badge bg-primary rounded-pill"><?= $totalKPIs ?></span>
                                                        </li>
                                                    </a>
                                                </ol><!-- End with custom content -->
                                            </div>

                                            <div class="col-12 mt-1">
                                                <canvas id="kpisCont" width="400" height="130"></canvas>
                                            </div>

                                            <script>
                                                const kpisCont = document.getElementById('kpisCont').getContext('2d');
                                                const kpisChart = new Chart(kpisCont, {
                                                    type: 'doughnut',
                                                    data: {
                                                        labels: ['Completed', 'Pending', 'Behind Schedule'],
                                                        datasets: [{
                                                            data: [<?= $completedKPIs ?>, <?= $activeKPIs ?>, <?= $dueKPIs ?>],
                                                            backgroundColor: [
                                                                'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                                'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                                'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                            ],
                                                            borderColor: [
                                                                'rgba(25, 135, 84, 1)',
                                                                'rgba(255, 193, 7, 1)',
                                                                'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                            ],
                                                            borderWidth: 1
                                                        }]
                                                    },
                                                    options: {
                                                        responsive: false,
                                                        plugins: {
                                                            legend: {
                                                                position: 'bottom'
                                                            }
                                                        }
                                                    }
                                                });
                                            </script>

                                        </div>

                                    </div>
                                </div>
                            </a>

                        </div><!-- End my kpis Card -->

                        <!-- initiatives Reports Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">Initiatives Reports</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Approved</div>
                                                    </div>
                                                    <span class="badge bg-success rounded-pill"><?= $approvedInitiativeReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Pending</div>
                                                    </div>
                                                    <span class="badge bg-warning rounded-pill"><?= $pendingInitiativeReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Rejected</div>
                                                    </div>
                                                    <span class="badge bg-danger rounded-pill"><?= $rejectedInitiativeReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Total</div>
                                                    </div>
                                                    <span class="badge bg-primary rounded-pill"><?= $totalInitiativeReports ?></span>
                                                </li>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="initiativesReportsCont" width="320" height="130"></canvas>
                                        </div>

                                        <script>
                                            const initiativesReportsCont = document.getElementById('initiativesReportsCont').getContext('2d');
                                            const initiativesReportsChart = new Chart(initiativesReportsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Approved', 'Pending', 'Due'],
                                                    datasets: [{
                                                        data: [<?= $approvedInitiativeReports ?>, <?= $pendingInitiativeReports ?>, <?= $rejectedInitiativeReports ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End initiatives Reports Card -->

                        <!-- kpi Reports Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">KPI Reports</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Approved</div>
                                                    </div>
                                                    <span class="badge bg-success rounded-pill"><?= $approvedKPIReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Pending</div>
                                                    </div>
                                                    <span class="badge bg-warning rounded-pill"><?= $pendingKPIReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Rejected</div>
                                                    </div>
                                                    <span class="badge bg-danger rounded-pill"><?= $rejectedKPIReports ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Total</div>
                                                    </div>
                                                    <span class="badge bg-primary rounded-pill"><?= $totalKPIReports ?></span>
                                                </li>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="kpiReportsCont" width="320" height="130"></canvas>
                                        </div>

                                        <script>
                                            const kpiReportsCont = document.getElementById('kpiReportsCont').getContext('2d');
                                            const kpiReportsChart = new Chart(kpiReportsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Approved', 'Pending', 'Due'],
                                                    datasets: [{
                                                        data: [<?= $approvedKPIReports ?>, <?= $pendingKPIReports ?>, <?= $rejectedKPIReports ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End KPI Reports Card -->
                    <?php endif; ?>

                    <!-- CSO Card -->
                    <?php if (in_array(session()->get('role'), ['chief_strategy_officer', 'superadmin', 'viewer'])): ?>
                        <!-- Themes Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">Strategic Themes</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">

                                                <a href="<?= base_url('themes?status=completed') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Completed</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $completedThemes ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('themes?status=active') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Active</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $activeThemes ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('themes?status=due') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Behind Schedule</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $dueThemes ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('themes') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Total</div>
                                                        </div>
                                                        <span class="badge bg-primary rounded-pill"><?= $totalThemes ?></span>
                                                    </li>
                                                </a>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="themesCont" width="440" height="130"></canvas>
                                        </div>

                                        <script>
                                            const themesCont = document.getElementById('themesCont').getContext('2d');
                                            const themesChart = new Chart(themesCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Completed', 'Active', 'Behind Schedule'],
                                                    datasets: [{
                                                        data: [<?= $completedThemes ?>, <?= $activeThemes ?>, <?= $dueThemes ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', ,
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- Themes Card -->

                        <!-- Gaols Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">High Level Goals</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('goals?status=completed') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Achieved</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $completedGoals ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('goals?status=active') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Active</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $activeGoals ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('goals?status=due') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Behind Schedule</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $dueGoals ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('goals') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Total</div>
                                                        </div>
                                                        <span class="badge bg-primary rounded-pill"><?= $totalGoals ?></span>
                                                    </li>
                                                </a>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="goalsCont" width="400" height="130"></canvas>
                                        </div>

                                        <script>
                                            const goalsCont = document.getElementById('goalsCont').getContext('2d');
                                            const goalsChart = new Chart(goalsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Achieved', 'Active', 'Behind Schedule'],
                                                    datasets: [{
                                                        data: [<?= $completedGoals ?>, <?= $activeGoals ?>, <?= $dueGoals ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- goals Card -->

                        <!-- Initiatives Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">Initiatives</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('initiatives?status=completed') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Completed</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $completedInitiatives ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('initiatives?status=active') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Active</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $activeInitiatives ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('initiatives?status=due') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Behind Schedule</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $dueInitiatives ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('initiatives') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Total</div>
                                                        </div>
                                                        <span class="badge bg-primary rounded-pill"><?= $totalInitiatives ?></span>
                                                    </li>
                                                </a>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="csoInitiativesCont" width="400" height="130"></canvas>
                                        </div>

                                        <script>
                                            const csoInitiativesCont = document.getElementById('csoInitiativesCont').getContext('2d');
                                            const csoInitiativesChart = new Chart(csoInitiativesCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Completed', 'Active', 'Behind Schedule'],
                                                    datasets: [{
                                                        data: [<?= $completedInitiatives ?>, <?= $activeInitiatives ?>, <?= $dueInitiatives ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>
                            </a>

                        </div><!-- Initiatives Card -->

                        <!-- KPIs Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">KPIs</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Completed</div>
                                                    </div>
                                                    <span class="badge bg-success rounded-pill"><?= $completedKPIs ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Active</div>
                                                    </div>
                                                    <span class="badge bg-warning rounded-pill"><?= $activeKPIs ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Behind Schedule</div>
                                                    </div>
                                                    <span class="badge bg-danger rounded-pill"><?= $dueKPIs ?></span>
                                                </li>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Total</div>
                                                    </div>
                                                    <span class="badge bg-primary rounded-pill"><?= $totalKPIs ?></span>
                                                </li>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="csoKPIsCont" width="400" height="130"></canvas>
                                        </div>

                                        <script>
                                            const csoKPIsCont = document.getElementById('csoKPIsCont').getContext('2d');
                                            const csoKPIsChart = new Chart(csoKPIsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Completed', 'Active', 'Behind Schedule'],
                                                    datasets: [{
                                                        data: [<?= $completedKPIs ?>, <?= $activeKPIs ?>, <?= $dueKPIs ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- KPIs Card -->

                        <!-- initiatives Reports Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">Initiative Reports</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('reports?type=initiative&status=approved') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Approved</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $approvedInitiativeReports ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('reports?type=initiative&status=pending') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Pending</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $pendingInitiativeReports ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('reports?type=initiative&status=rejected') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Rejected</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $rejectedInitiativeReports ?></span>
                                                    </li>
                                                </a>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Total</div>
                                                    </div>
                                                    <span class="badge bg-primary rounded-pill"><?= $totalInitiativeReports ?></span>
                                                </li>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="csoInitiativesReportsCont" width="350" height="130"></canvas>
                                        </div>

                                        <script>
                                            const csoInitiativesReportsCont = document.getElementById('csoInitiativesReportsCont').getContext('2d');
                                            const csoInitiativesReportsCharts = new Chart(csoInitiativesReportsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Approved', 'Pending', 'Rejected'],
                                                    datasets: [{
                                                        data: [<?= $approvedInitiativeReports ?>, <?= $pendingInitiativeReports ?>, <?= $rejectedInitiativeReports ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End initiatives Reports Card -->

                        <!-- kpi Reports Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">KPI Reports</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('reports?type=kpi&status=approved') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Approved</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $approvedKPIReports ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('reports?type=kpi&status=pending') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Pending</div>
                                                        </div>
                                                        <span class="badge bg-warning rounded-pill"><?= $pendingKPIReports ?></span>
                                                    </li>
                                                </a>

                                                <a href="<?= base_url('reports?type=kpi&status=rejected') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Rejected</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $rejectedKPIReports ?></span>
                                                    </li>
                                                </a>
                                                <li class="list-group-item d-flex justify-content-between align-items-start">
                                                    <div class="ms-2 me-auto">
                                                        <div class="fw-bold">Total</div>
                                                    </div>
                                                    <span class="badge bg-primary rounded-pill"><?= $totalKPIReports ?></span>
                                                </li>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="csokpiReportsCont" width="350" height="130"></canvas>
                                        </div>

                                        <script>
                                            const csokpiReportsCont = document.getElementById('csokpiReportsCont').getContext('2d');
                                            const csokpiReportsCharts = new Chart(csokpiReportsCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Approved', 'Pending', 'Rejected'],
                                                    datasets: [{
                                                        data: [<?= $approvedKPIReports ?>, <?= $pendingKPIReports ?>, <?= $rejectedKPIReports ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(255, 193, 7, 0.7)', // Bootstrap warning yellow
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(255, 193, 7, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End KPI Reports Card -->
                    <?php endif; ?>

                    <!-- admin dashboard -->
                    <?php if (in_array(session()->get('role'), ['admin'])): ?>
                        <!-- users Card -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title large-text">Users</h5>

                                    <div class="row">
                                        <div class="col-12">
                                            <!-- List group with custom content -->
                                            <ol class="list-group">
                                                <a href="<?= base_url('users?status=active') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Active</div>
                                                        </div>
                                                        <span class="badge bg-success rounded-pill"><?= $activeUsers ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('users?status=inactive') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Inactive</div>
                                                        </div>
                                                        <span class="badge bg-danger rounded-pill"><?= $inactiveUsers ?></span>
                                                    </li>
                                                </a>
                                                <a href="<?= base_url('users') ?>">
                                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                                        <div class="ms-2 me-auto">
                                                            <div class="fw-bold">Total</div>
                                                        </div>
                                                        <span class="badge bg-primary rounded-pill"><?= $totalUsers ?></span>
                                                    </li>
                                                </a>
                                            </ol><!-- End with custom content -->
                                        </div>

                                        <div class="col-12 mt-1">
                                            <canvas id="usersCont" width="350" height="130"></canvas>
                                        </div>

                                        <script>
                                            const usersCont = document.getElementById('usersCont').getContext('2d');
                                            const usersChart = new Chart(usersCont, {
                                                type: 'doughnut',
                                                data: {
                                                    labels: ['Active', 'Inactive'],
                                                    datasets: [{
                                                        data: [<?= $activeUsers ?>, <?= $inactiveUsers ?>],
                                                        backgroundColor: [
                                                            'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                            'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                                        ],
                                                        borderColor: [
                                                            'rgba(25, 135, 84, 1)',
                                                            'rgba(220, 53, 69, 0.7)',
                                                        ],
                                                        borderWidth: 1
                                                    }]
                                                },
                                                options: {
                                                    responsive: false,
                                                    plugins: {
                                                        legend: {
                                                            position: 'bottom'
                                                        }
                                                    }
                                                }
                                            });
                                        </script>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End users Card -->
                    <?php endif; ?>

                </div>
            </div>
        </div>
</main>
<?= $this->endSection() ?>