<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('users') ?>">Users</a></li>
                    <li class="breadcrumb-item active"><a href="#">Update</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Update Users -->
            <?php if (!empty($user)) : ?>
                <div class="col-12">
                    <div class="card recent-sales overflow-auto">

                        <div class="card-body">
                            <h1 class="my-4 medium-text">Update User</h1>

                            <form action="<?= base_url('update/users/' . $user['slug']) ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                <?= csrf_field() ?>
                                <input type="hidden" name="_method" value="PUT">
                                <input type="hidden" name="id" value="<?= $user['id'] ?>">

                                <div class="row">
                                    <div class="mb-3 col-6">
                                        <label for="type" class="form-label">User Category</label>
                                        <select name="type" class="form-input">
                                            <option value="">User Category</option>
                                            <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : '' ?>>Admin</option>
                                            <option value="chief_startegy_officer" <?= $user['role'] === 'chief_startegy_officer' ? 'selected' : '' ?>>Chief Strategy Officer</option>
                                            <option value="department_head" id="department_head" <?= $user['role'] === 'department_head' ? 'selected' : '' ?>>Department Head</option>
                                            <option value="project_lead" <?= $user['role'] === 'project_lead' ? 'selected' : '' ?>>Project Lead</option>
                                            <option value="viewer" <?= $user['role'] === 'viewer' ? 'selected' : '' ?>>Viewer</option>
                                        </select>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('type') : '' ?></p>
                                    </div>

                                    <div class="mb-3 col-6" id="organizationstructures_id">
                                        <label for="organizationstructures_id" class="form-label">Department</label>
                                        <select name="organizationstructures_id" class="form-input">
                                        <option value="">Choose Structure</option>
                                        <?php if (!empty($structures)) : ?>
                                            <?php foreach ($structures as $structure) : ?>
                                                <option value="<?= esc($structure['id']) ?>"><?= esc($structure['name']) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('organizationstructures_id') : '' ?></p>
                                    </div>

                                    <div class="mb-3 col-6">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" class="form-input" name="name" value="<?= esc($user['name']) ?>">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                    </div>

                                    <div class="mb-3 col-6">
                                        <label for="phone" class="form-label">Phone <small class="text-muted">(Optional)</small></label>
                                        <input type="number" class="form-input" name="phone" placeholder="Phone" value="<?= esc($user['phone']) ?>">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('phone') : '' ?></p>
                                    </div>

                                    <div class="mb-3 col-6">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="text" class="form-input" name="email" placeholder="Email" value="<?= esc($user['email']) ?>">
                                        <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
                                    </div>
                                </div>
                                <button class="btn btn-pink w-100" x-ref="btn">Update</button>

                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

</main>

<?= $this->endSection() ?>