<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('users') ?>">Users</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <?php if (in_array(session()->get('role'), ['superadmin', 'viewer', 'chief_strategy_officer', 'admin'])): ?>
        <section class="section dashboard">
            <div class="row g-4">

                <!-- Organizations -->

                <div class="col-12">
                    <div class="card recent-sales overflow-auto">

                        <div class="card-body">

                        <div class="filter text-end">
                            <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                </li>

                                <li><a class="dropdown-item" href="<?= base_url('users?status=active') ?>">Active</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('users?status=inactive') ?>">Inactive</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('users') ?>">All</a></li>
                            </ul>
                        </div>

                            <?php if (!empty($organization)) : ?>
                                <h5 class="card-title large-text">Users
                                    <?php if (in_array(session()->get('role'), ['superadmin', 'admin'])): ?>
                                        <span>| <a href="<?= base_url('users/create') ?>" class="btn btn-sm text-primary">Add new</a></span>
                                    <?php endif; ?>
                                </h5>

                            <?php endif; ?>
                            <?php if (!empty($users)) : ?>
                                <table class="table table-hover table-bordered datatable">
                                    <thead>
                                        <tr>
                                            <th scope="col" class="text-bg-secondary">Name</th>
                                            <th scope="col" class="text-bg-secondary">Email</th>
                                            <th scope="col" class="text-bg-secondary">Phone</th>
                                            <th scope="col" class="text-bg-secondary">Structure</th>
                                            <th scope="col" class="text-bg-secondary">Role</th>
                                            <th scope="col" class="text-bg-secondary">Status</th>
                                            <th scope="col" class="text-bg-secondary">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($users as $user) : ?>
                                            <tr>
                                                <td><?= esc($user['name']) ?></td>
                                                <td><?= esc($user['email']) ?></td>
                                                <td><?= esc($user['phone']) ?? '' ?></td>
                                                <td><?= esc($user['structure_name']) ?? '' ?></td>
                                                <td>
                                                    <?php if ($user['role'] === 'department_head' && !empty($user['structure_name'])): ?>
                                                        Department Head <?= esc($user['structure_name']) ?>
                                                    <?php else: ?>
                                                        <?= ucwords(str_replace('_', ' ', esc($user['role']))) ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td><span class="badge <?= esc($user['status']) === 'active' ? 'text-bg-dark' : 'text-bg-danger' ?>"><?= esc($user['status']) ?></span></td>
                                                <td>
                                                    <div class="status-actions">
                                                        <div class="actions">
                                                            <?php if (in_array(session()->get('role'), ['superadmin', 'admin'])): ?>
                                                                <a href="<?= base_url('update/users/' . $user['slug']) ?>" class="action-btn text-bg-success" title="Edit">
                                                                    <i class="fa fa-edit ms-1" style="font-size:15px"></i>
                                                                </a>
                                                            <?php endif; ?>

                                                            <?php if ($user['status'] === 'active') : ?>

                                                                <?php if (in_array(session()->get('role'), ['superadmin', 'admin'])): ?>
                                                                    <form action="<?= base_url('users/disable/' . esc($user['id'])) ?>" method="post" style="display:inline;">
                                                                        <?= csrf_field() ?>

                                                                        <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                            <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                        </button>
                                                                    </form>
                                                                <?php endif; ?>

                                                                <div class="dropdown">
                                                                    <button class="btn text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                        more
                                                                    </button>
                                                                    <ul class="dropdown-menu">
                                                                        <li><a class="dropdown-item" href="<?= base_url('user/'  . $user['slug'] . '/my-initiatives') ?>">Initiatives</a></li>
                                                                        <li><a class="dropdown-item" href="<?= base_url('user/'  . $user['slug'] . '/my-kpis') ?>">KPIs</a></li>
                                                                    </ul>
                                                                </div>

                                                            <?php else: ?>
                                                                <?php if (in_array(session()->get('role'), ['superadmin', 'admin'])): ?>
                                                                    <form action="<?= base_url('users/enable/' . esc($user['id'])) ?>" method="post" style="display:inline;">
                                                                        <?= csrf_field() ?>

                                                                        <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                            <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                        </button>
                                                                    </form>

                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>

                                    </tbody>
                                </table>
                            <?php else : ?>
                                <div class="alert alert-info">No users found</div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div><!-- end users -->
            </div>
        </section>
    <?php endif; ?>
</main>

<?= $this->endSection() ?>