<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">User</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-12">
                <!-- loop out the initiatives if available -->
                <div class="card">
                    <div class="card-body">

                        <?php if (in_array(session()->get('role'), ['project_lead', 'department_head'])): ?>
                            <div class="filter text-end">
                                <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                    <li class="dropdown-header text-start">
                                        <h6>Filter</h6>
                                    </li>

                                    <li><a class="dropdown-item" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=completed') ?>">Completed</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=active') ?>">Active</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=inactive') ?>">Inactive</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis?status=due') ?>">Behind Schedule</a></li>
                                    <li><a class="dropdown-item" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis') ?>">All</a></li>
                                </ul>
                            </div>

                        <?php endif ?>
                        <h4 class="large-text card-title">KPIS</h4>
                        <?php if (!empty($kpis)) : ?>
                            <table class="table table-hover datatable table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-bg-secondary">KPI</th>
                                        <th scope="col" class="text-bg-secondary">Exp. date of completion</th>
                                        <th scope="col" class="text-bg-secondary">Status</th>
                                        <th scope="col" class="text-bg-secondary">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($kpis as $kpi) : ?>
                                        <?php /*

                                        $statusColor = '';
                                        if ($kpi['status'] === 'active') {
                                            $statusColor = 'bg-warning';
                                        }

                                        if ($kpi['status'] === 'completed') {
                                            $statusColor = 'bg-success';
                                        }

                                        if ($kpi['status'] === 'inactive') {
                                            $statusColor = 'bg-danger';
                                        } */
                                        ?>
                                        <tr>
                                            <td><?= esc($kpi['name']) ?? '' ?></td>
                                            <td><?= (new DateTime($kpi['timeline']))->format('d F, Y') ?></td>
                                            <td><span class="badge text-bg-dark"><?= esc($kpi['status']) ?></span></td>
                                            <td>
                                                <div class="status-actions">
                                                    <div class="actions">

                                                        <div class="dropdown">
                                                            <button class="btn text-bg-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                more
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li><a class="dropdown-item" href="<?= base_url('my-kpis/' . $kpi['slug'] . '/submissions') ?>">Reports</a></li>
                                                                <li><a class="dropdown-item" href="<?= base_url('my-kpis/' . $kpi['slug'] . '/comments') ?>">Comments</a></li>
                                                                <button type="button" class="btn dropdown-item" data-bs-toggle="modal" data-bs-target="#<?= $kpi['slug'] ?>">
                                                                    Add to Calendar
                                                                </button>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                        <!-- Vertically centered Modal -->
                                        <div class="modal fade" id="<?= $kpi['slug'] ?>" tabindex="-1">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>

                                                    <div class="modal-body text-center">
                                                        <p class="mb-4">
                                                            Add <strong><?= esc($kpi['name']) ?></strong>
                                                            to your calendar.
                                                            <br>
                                                            End Date: <strong><?= esc($kpi['timeline']) ?></strong>
                                                        </p>

                                                        <div class="d-flex flex-column align-items-center gap-3">
                                                            <!-- Google Calendar -->
                                                            <a href="<?= base_url('google-calendar/render?type=kpi&kpi=' . $kpi['slug']) ?>"
                                                                target="_blank" class="btn btn-outline-danger d-flex align-items-center justify-content-center w-75">
                                                                <img src="<?= base_url('assets/icons/google_logo.png') ?>" alt="Google" class="me-2" style="width:24px; height:24px;">
                                                                <span>Google Calendar</span>
                                                            </a>

                                                            <!-- Outlook Calendar -->
                                                            <?php /*
                                                            <a href="https://outlook.live.com/calendar/0/deeplink/compose?subject=<?= urlencode($kpi['name']) ?>&enddt=<?= date('Y-m-d\TH:i:s', strtotime($kpi['timeline'])) ?>"
                                                                target="_blank" class="btn btn-outline-primary d-flex align-items-center justify-content-center w-75">
                                                                <img src="<?= base_url('assets/icons/microsoft_logo.png') ?>"
                                                                    alt="Microsoft" class="me-2" style="width:24px; height:24px;">
                                                                <span>Outlook Calendar</span>
                                                            </a>
                                                            */ ?>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End Vertically centered Modal -->
                                    <?php endforeach; ?>

                                </tbody>
                            </table>
                    </div>
                <?php else : ?>
                    <div class="alert alert-info">No KPIs found</div>
                <?php endif; ?>
                </div>
            </div>
        </div>
        </div>

        </div>
    </section>

</main>
<?= $this->endSection() ?>