<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row">

            <div class="col-12">
                <div class="text-end mt-2">
                    <a href="<?= base_url('strategy-map?action=download') ?>" class="btn btn-sm" target="_blank">Export Strategy Map</a>
                </div>
                <div class="card info-card sales-card">
                    <div class="card-body">

                        <?php
                            $goalsWithPerspective = $strategyMatrix['with_perspective'] ?? [];
                            $goalsWithoutPerspective = $strategyMatrix['without_perspective'] ?? [];
                        ?>

                        <?php if (!empty($themes)) : ?>
                            <h5 class="card-title large-text text-center">Our Strategy Map</h5>

                            <div class="table-responsive">

                                <?php if (!empty($perspectives) && !empty($goalsWithPerspective)) : ?>
                                    <?php
                                    // Build matrix: goals[pid][tid] = [goal1, goal2...]
                                    $goalMap = [];
                                    foreach ($goalsWithPerspective as $goal) {
                                        $pid = $goal['bscperspective_id'];
                                        $tid = $goal['theme_id'];
                                        $goalMap[$pid][$tid][] = $goal['description'];
                                    }
                                    ?>
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th class="text-bg-secondary"></th>
                                                <?php foreach ($themes as $theme): ?>
                                                    <th class="text-bg-secondary"><?= ucfirst(esc($theme['title'])) ?></th>
                                                <?php endforeach; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($perspectives as $persp): ?>
                                                <tr>
                                                    <td class="text-bg-secondary"><strong><?= ucfirst(esc($persp['name'])) ?></strong></td>
                                                    <?php foreach ($themes as $theme): ?>
                                                        <td>
                                                            <?php
                                                            $goals = $goalMap[$persp['id']][$theme['id']] ?? [];
                                                            if ($goals): ?>
                                                                <?php foreach ($goals as $goal): ?>
                                                                    <span><?= html_entity_decode($goal) ?></span><br>
                                                                <?php endforeach; ?>
                                                            <?php else: ?>
                                                                &mdash;
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endforeach; ?>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>

                                <?php elseif (!empty($goalsWithoutPerspective)) : ?>
                                    <!-- Strategy Map Without Perspectives -->
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <?php foreach ($themes as $theme): ?>
                                                    <th class="text-bg-secondary"><?= ucfirst(esc($theme['title'])) ?></th>
                                                <?php endforeach; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <?php foreach ($themes as $theme): ?>
                                                    <td>
                                                        <?php
                                                        $goals = $goalsWithoutPerspective[$theme['id']] ?? [];
                                                        if ($goals): ?>
                                                            <?php foreach ($goals as $goal): ?>
                                                                <span><?= html_entity_decode($goal) ?></span><br>
                                                            <?php endforeach; ?>
                                                        <?php else: ?>
                                                            &mdash;
                                                        <?php endif; ?>
                                                    </td>
                                                <?php endforeach; ?>
                                            </tr>
                                        </tbody>
                                    </table>
                                <?php else : ?>
                                    <p class="text-center">No goals available for mapping. Add goals to your strategic themes.</p>
                                <?php endif; ?>

                            </div>
                        <?php else : ?>
                            <h5 class="card-title large-text text-center">Create strategic themes and their goals to create your strategy map</h5>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

        </div>
    </section>
</main>

<?= $this->endSection() ?>
