<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <h1>STracker</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
            </ol>
        </nav>
    </div><!-- End Page Title -->
    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h5 class="card-title large-text">Contacts
                        </h5>

                        <?php if (!empty($contacts)) : ?>
                                    <!-- Responsive Table Wrapper -->
                                    <div class="table-responsive">
                                        <table class="table table-hover table-bordered align-middle mb-0 datatable">
                                            <thead class="table-secondary text-center">
                                                <tr>
                                                    <th scope="col">Application</th>
                                                    <th scope="col">Name</th>
                                                    <th scope="col">Email</th>
                                                    <th scope="col">WhatsApp No.</th>
                                                    <th scope="col">Name of Organization</th>
                                                    <th scope="col">Role in Organization</th>
                                                    <th scope="col">Message</th>
                                                    <th scope="col">Sent At</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($contacts as $contact) : ?>
                                                    <tr>
                                                        <td><?= esc($contact['application']) ?></td>
                                                        <td><?= esc($contact['name']) ?></td>
                                                        <td><?= esc($contact['email']) ?></td>
                                                        <td><?= esc($contact['whatsapp_no']) ?></td>
                                                        <td><?= esc($contact['name_of_org']) ?></td>
                                                        <td><?= esc($contact['role_in_org']) ?></td>
                                                        <td><?= esc($contact['message']) ?></td>
                                                        <td><?= (new DateTime($contact['created_at']))->format('d F, Y') ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else : ?>
                                    <div class="alert alert-info">No contacts found</div>
                                <?php endif; ?>
                    </div>

                </div>
            </div><!-- end users -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>