<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('users') ?>">Users</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <!-- display form for creating an item in the organiation structure -->

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Add new users Users -->

            <div class="col-lg-6">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h1 class="my-4 medium-text card-title">Add Super Admin</h1>

                        <form action="<?= base_url('superadmin/new') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>

                            <div class="row">
                                <div class="mb-3 col-12">
                                    <label for="name" class="form-label">Name</label>
                                    <input type="text" class="form-input" name="name" value="<?= set_value('name') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                </div>

                                <div class="mb-3 col-12">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="text" class="form-input" name="email" placeholder="Email" value="<?= set_value('email') ?>">
                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
                                </div>
                            </div>
                            <button class="btn btn-pink w-100" x-ref="btn">Add Super Admin</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<?= $this->endSection() ?>