<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <h1>STracker</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
            </ol>
        </nav>
    </div><!-- End Page Title -->
    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h5 class="card-title large-text">Super Admins
                            <?php if (in_array(session()->get('role'), ['superadmin'])): ?>
                                <span>| <a href="<?= base_url('superadmin/new') ?>" class="btn btn-sm text-primary">Add new</a></span>
                        </h5>

                    <?php endif; ?>
                    <?php if (!empty($superadmins)) : ?>
                        <table class="table table-hover table-bordered datatable">
                            <thead>
                                <tr>
                                    <th scope="col" class="text-bg-secondary">Name</th>
                                    <th scope="col" class="text-bg-secondary">Email</th>
                                    <th scope="col" class="text-bg-secondary">Phone</th>
                                    <th scope="col" class="text-bg-secondary">Role</th>
                                    <th scope="col" class="text-bg-secondary">Status</th>
                                    <th scope="col" class="text-bg-secondary">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($superadmins as $superadmin) : ?>
                                    <tr>
                                        <td><?= esc($superadmin['name']) ?></td>
                                        <td><?= esc($superadmin['email']) ?></td>
                                        <td><?= esc($superadmin['phone']) ?? '' ?></td>
                                        <td><?= esc($superadmin['role']) ?? '' ?></td>
                                        <td><span class="badge <?= esc($superadmin['status']) === 'active' ? 'bg-success' : 'bg-danger' ?>"><?= esc($superadmin['status']) ?></span></td>
                                        <td>
                                            <div class="status-actions">
                                                <div class="actions">

                                                    <?php if ($superadmin['status'] === 'active') : ?>

                                                        <?php if (in_array(session()->get('role'), ['superadmin'])): ?>
                                                            <form action="<?= base_url('superadmin/disable/' . esc($superadmin['id'])) ?>" method="post" style="display:inline;">
                                                                <?= csrf_field() ?>

                                                                <button class="action-btn text-bg-danger" title="Deactivate" type="submit">
                                                                    <i class="fa fa-power-off" style="font-size:15px"></i>
                                                                </button>
                                                            </form>
                                                        <?php endif; ?>

                                                    <?php else: ?>
                                                        <?php if (in_array(session()->get('role'), ['superadmin', 'admin'])): ?>
                                                            <form action="<?= base_url('superadmin/enable/' . esc($superadmin['id'])) ?>" method="post" style="display:inline;">
                                                                <?= csrf_field() ?>

                                                                <button class="action-btn text-bg-warning" title="Activate" type="submit">
                                                                    <i class="fa fa-toggle-on" style="font-size:15px"></i>
                                                                </button>
                                                            </form>

                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; ?>

                            </tbody>
                        </table>

                    <?php endif; ?>
                    </div>

                </div>
            </div><!-- end users -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>