<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>Dashboard</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Home</a></li>
                <li class="breadcrumb-item active">Dashboard</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
        <div class="row">

            <!-- organizations Card -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title large-text">Organizations</h5>

                        <div class="row">
                            <div class="col-12">
                                <!-- List group with custom content -->
                                <ol class="list-group">
                                    <a href="<?= base_url('organizations?status=active') ?>">
                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                            <div class="ms-2 me-auto">
                                                <div class="fw-bold">Active</div>
                                            </div>
                                            <span class="badge bg-success rounded-pill"><?= $activeOrganizations ?></span>
                                        </li>
                                    </a>
                                    <a href="<?= base_url('organizations?status=inactive') ?>">
                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                            <div class="ms-2 me-auto">
                                                <div class="fw-bold">Inactive</div>
                                            </div>
                                            <span class="badge bg-danger rounded-pill"><?= $inactiveOrganizations ?></span>
                                        </li>
                                    </a>

                                    <a href="<?= base_url('organizations') ?>">
                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                            <div class="ms-2 me-auto">
                                                <div class="fw-bold">Total</div>
                                            </div>
                                            <span class="badge bg-primary rounded-pill"><?= $totalOrganizations ?></span>
                                        </li>
                                    </a>
                                </ol><!-- End with custom content -->
                            </div>

                            <div class="col-12 mt-1">
                                <canvas id="organizationsCont" width="350" height="130"></canvas>
                            </div>

                            <script>
                                const organizationsCont = document.getElementById('organizationsCont').getContext('2d');
                                const organizationsChart = new Chart(organizationsCont, {
                                    type: 'doughnut',
                                    data: {
                                        labels: ['Active', 'Inactive'],
                                        datasets: [{
                                            data: [<?= $activeOrganizations ?>, <?= $inactiveOrganizations ?>],
                                            backgroundColor: [
                                                'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                            ],
                                            borderColor: [
                                                'rgba(25, 135, 84, 1)',
                                                'rgba(220, 53, 69, 0.7)',
                                            ],
                                            borderWidth: 1
                                        }]
                                    },
                                    options: {
                                        responsive: false,
                                        plugins: {
                                            legend: {
                                                position: 'bottom'
                                            }
                                        }
                                    }
                                });
                            </script>

                        </div>

                    </div>
                </div>

            </div><!-- End organizations Card -->

            <!-- users Card -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title large-text">Users</h5>

                        <div class="row">
                            <div class="col-12">
                                <!-- List group with custom content -->
                                <ol class="list-group">
                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                        <div class="ms-2 me-auto">
                                            <div class="fw-bold">Active</div>
                                        </div>
                                        <span class="badge bg-success rounded-pill"><?= $activeUsers ?></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                        <div class="ms-2 me-auto">
                                            <div class="fw-bold">Inactive</div>
                                        </div>
                                        <span class="badge bg-danger rounded-pill"><?= $inactiveUsers ?></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-start">
                                        <div class="ms-2 me-auto">
                                            <div class="fw-bold">Total</div>
                                        </div>
                                        <span class="badge bg-primary rounded-pill"><?= $totalUsers ?></span>
                                    </li>
                                </ol><!-- End with custom content -->
                            </div>

                            <div class="col-12 mt-1">
                                <canvas id="usersCont" width="350" height="130"></canvas>
                            </div>

                            <script>
                                const usersCont = document.getElementById('usersCont').getContext('2d');
                                const usersChart = new Chart(usersCont, {
                                    type: 'doughnut',
                                    data: {
                                        labels: ['Active', 'Inactive'],
                                        datasets: [{
                                            data: [<?= $activeUsers ?>, <?= $inactiveUsers ?>],
                                            backgroundColor: [
                                                'rgba(25, 135, 84, 0.7)', // Bootstrap success green
                                                'rgba(220, 53, 69, 0.7)', // Bootstrap danger red
                                            ],
                                            borderColor: [
                                                'rgba(25, 135, 84, 1)',
                                                'rgba(220, 53, 69, 0.7)',
                                            ],
                                            borderWidth: 1
                                        }]
                                    },
                                    options: {
                                        responsive: false,
                                        plugins: {
                                            legend: {
                                                position: 'bottom'
                                            }
                                        }
                                    }
                                });
                            </script>

                        </div>

                    </div>
                </div>

            </div><!-- End users Card -->
        </div>
</main>
<?= $this->endSection() ?>